/**
	Copyright (c) 2008, hedachi ( http://blog.pettan.jp/ )
	All rights reserved.

	Redistribution and use in source and binary forms, with or without modification,
	are permitted provided that the following conditions are met:

	1. Redistributions of source code must retain the above copyright notice,
	   this list of conditions and the following disclaimer.
	2. Redistributions in binary form must reproduce the above copyright notice,
	   this list of conditions and the following disclaimer in the documentation
	   and/or other materials provided with the distribution.
	3. Neither the name of the pettan nor the names of its contributors may be used
	   to endorse or promote products derived from this software without specific
	   prior written permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
	EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
	OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
	SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
	TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
	BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
	ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
	DAMAGE.
*/

package peta.dao;

import java.util.Date;

public class Comic {
    private Long comicID;
    private Long firstKomaID;
    private String title;
    private Date updateDate;
    private Integer pageCount;
    private Integer comeCount;
    private String explanation;
    private Integer autoMoveSec;
    private String delFlg;
    private String makerFreeFlg;
    private Integer pageView;
    private Integer authorID;
    private Date birthday;
    private Long coverImageID;
    private Long coverBgImageID;
    private String type;
    private Integer defKomaWidth;
    private Integer defKomaHeight;
    private Koma firstPage;
    private Image coverImage;
    private Image coverBgImage;
    private Usr author;

    public String getMakerFreeFlgLabel() {
        if (getMakerFreeFlg() == null)
            return "";
        if ("0".equals(getMakerFreeFlg()))
            return "作成者のみ投稿可能";
        if ("1".equals(getMakerFreeFlg()))
            return "誰でも投稿可能";
        if ("2".equals(getMakerFreeFlg()))
            return "<b>投稿不可</b>";
        return "";
    }

    public String getCoverColor() {
        if ("2".equals(getDelFlg()))
            return "#ffd0d0";
        if ("2".equals(getMakerFreeFlg()))
            return "#d0d0ff";
        return "#f0f0f0";
    }

    public boolean isKomaMakable(Usr u) {
        if ("1".equals(getMakerFreeFlg()))
            return true;
        if ("2".equals(getMakerFreeFlg()))
            return false;
        return ("0".equals(getMakerFreeFlg())) && (u != null)
                && (u.getUsrID().equals(getAuthorID()));
    }

    public Usr getAuthor() {
        return this.author;
    }

    public void setAuthor(Usr author) {
        this.author = author;
    }

    public Image getCoverBgImage() {
        return this.coverBgImage;
    }

    public void setCoverBgImage(Image coverBgImage) {
        this.coverBgImage = coverBgImage;
    }

    public Image getCoverImage() {
        return this.coverImage;
    }

    public void setCoverImage(Image coverImage) {
        this.coverImage = coverImage;
    }

    public String getDelFlg() {
        return this.delFlg;
    }

    public void setDelFlg(String delFlg) {
        this.delFlg = delFlg;
    }

    public Integer getAutoMoveSec() {
        return this.autoMoveSec;
    }

    public void setAutoMoveSec(Integer autoMoveSec) {
        this.autoMoveSec = autoMoveSec;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public Integer getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    public Comic() {
        setUpdateDate(new Date());
        setBirthday(new Date());
        setAutoMoveSec(Integer.valueOf(0));
        setDelFlg("0");
        setMakerFreeFlg("0");
        setType("1");
        setPageView(Integer.valueOf(0));
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getComicID() {
        return this.comicID;
    }

    public void setComicID(Long comicID) {
        this.comicID = comicID;
    }

    public Koma getFirstPage() {
        return this.firstPage;
    }

    public void setFirstPage(Koma firstPage) {
        this.firstPage = firstPage;
    }

    public Long getFirstKomaID() {
        return this.firstKomaID;
    }

    public void setFirstKomaID(Long firstKomaID) {
        this.firstKomaID = firstKomaID;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Integer getComeCount() {
        return this.comeCount;
    }

    public void setComeCount(Integer comeCount) {
        this.comeCount = comeCount;
    }

    public String getMakerFreeFlg() {
        return this.makerFreeFlg;
    }

    public void setMakerFreeFlg(String makerFreeFlg) {
        this.makerFreeFlg = makerFreeFlg;
    }

    public Integer getPageView() {
        return this.pageView;
    }

    public void setPageView(Integer pageView) {
        this.pageView = pageView;
    }

    public Integer getAuthorID() {
        return this.authorID;
    }

    public void setAuthorID(Integer authorID) {
        this.authorID = authorID;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public void setBirthday(Date birthday) {
        this.birthday = birthday;
    }

    public Long getCoverBgImageID() {
        return this.coverBgImageID;
    }

    public void setCoverBgImageID(Long coverBgImageID) {
        this.coverBgImageID = coverBgImageID;
    }

    public Long getCoverImageID() {
        return this.coverImageID;
    }

    public void setCoverImageID(Long coverImageID) {
        this.coverImageID = coverImageID;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getDefKomaHeight() {
        return this.defKomaHeight;
    }

    public void setDefKomaHeight(Integer defKomaHeight) {
        this.defKomaHeight = defKomaHeight;
    }

    public Integer getDefKomaWidth() {
        return this.defKomaWidth;
    }

    public void setDefKomaWidth(Integer defKomaWidth) {
        this.defKomaWidth = defKomaWidth;
    }
}
