<%--
  ~ Copyright (c) 2008, hedachi ( http://blog.pettan.jp/ )
  ~ All rights reserved.
  ~ 
  ~ Redistribution and use in source and binary forms, with or without modification,
  ~ are permitted provided that the following conditions are met:
  ~ 
  ~ 1. Redistributions of source code must retain the above copyright notice,
  ~    this list of conditions and the following disclaimer.
  ~ 2. Redistributions in binary form must reproduce the above copyright notice,
  ~    this list of conditions and the following disclaimer in the documentation
  ~    and/or other materials provided with the distribution.
  ~ 3. Neither the name of the pettan nor the names of its contributors may be used
  ~    to endorse or promote products derived from this software without specific
  ~    prior written permission.
  ~ 
  ~ THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
  ~ EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  ~ OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
  ~ SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
  ~ INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  ~ TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
  ~ BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  ~ CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
  ~ ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
  ~ DAMAGE.
  --%>

<%@ page language="java" import="java.lang.*,java.util.*,ninnik.util.*,peta.dao.*" pageEncoding="UTF-8" %>
<%@ include file="./inc/commonDirective.jsp" %>

<bean:define id="jspName" value="viewComic" type="java.lang.String"/>
<bean:define id="comic" name="comic" type="peta.dao.Comic"/>
<bean:define id="author" name="author" type="peta.dao.Usr"/>
<bean:define id="goNext" type="String">/</bean:define>
<bean:define id="goPrevious" type="String">/</bean:define>

	<logic:notEqual name="comic" property="type" value="U">
		<%if( comic.isKomaMakable(usr) ){%>
		<%}%>
	</logic:notEqual>
<%
boolean inIFrame = false;
boolean 複数コマ = ( "0".equals(comic.getType()) )? false : true ;
String previewFlg = (String)request.getAttribute("previewFlg");
Integer コマ番号From = (Integer)request.getAttribute("コマ番号From");
Integer コマ番号To = (Integer)request.getAttribute("コマ番号To");
Integer 総コマ数 = (Integer)request.getAttribute("総コマ数");
boolean 作成 = ( !"U".equals(comic.getType()) && comic.isKomaMakable(usr) )? true : false;
Integer editSeqNO = (Integer)request.getAttribute("editSeqNO");
Koma editTargetKoma = null;
noHeaderFooter = ( Boolean.TRUE.equals( request.getAttribute("noHeaderFooter") ) )? true : false;
forInsert = ( Boolean.TRUE.equals( request.getAttribute("forInsert") ) )? true : false;
%>

<html:html>
<head>
<title><bean:write name="comic" property="title"/> - <bean:message key="title" bundle="depEnv"/></title>
<script type="text/javascript" src="pages/gatherer/make_js_gat.jsp"></script>
<%@ include file="./inc/commonHeader.jsp" %>
<logic:notEqual name="comic" property="type" value="U">
	<%@ include file="./inc/makeKomaHeader.jsp" %>
</logic:notEqual>
</head>
<body>
<%@ include file="./inc/commonBody.jsp" %>
<div id="main">
	<%if( !"1".equals(previewFlg) ){%>
	<%@ include file="./inc/headerL.jsp" %>
	<%@ include file="./inc/headerC.jsp" %>
	<%@ include file="./inc/headerR.jsp" %>
	<html:errors/>
	<%}%>
	<h3>
		<bean:write name="comic" property="title"/>
	</h3>
	<span class="h3Font">
	（<bean:write name="comic" property="pageCount"/>）
	</span>
	<%
	if( コマ番号From != null && コマ番号To != null ) { %><b><bean:write name="コマ番号From"/></b>&nbsp;～&nbsp;<b><bean:write name="コマ番号To"/></b>&nbsp;コマ目を<%	}
	else if ( コマ番号From != null ) {%><b><bean:write name="コマ番号From"/></b>コマ目から最新までを<%}
	else {%>最新&nbsp;<b><%= peta.定数.コマ表示数 %></b>&nbsp;コマを<% }
	%><logic:equal name="comic" property="type" value="U">新しい順に</logic:equal>表示
	&nbsp;<%=Utils.getHatebuLink( "/comic" + comic.getComicID() )%>
	
	<br/><br/>
	<%@ include file="./inc/viewComicPager.jsp" %>
	<%@ include file="./inc/usrComicPager.jsp" %>
	<br/>
	
	<%--★★ ページ ★★--%>
	<% int ei = 0;%>
	<% int pi = 0;%>
	<logic:iterate id="p" name="pages" type="Koma" indexId="i">

		<bean:define id="pageAuthor" property="author" name="p" type="Usr"/>

		<% if( ! p.getSeqNO().equals( editSeqNO ) ){ %>
			<div id="<bean:write name="p" property="seqNO" />">
				<%@ include file="./inc/viewKomaHeader.jsp" %>
				<%@ include file="./inc/viewKoma.jsp" %>
				<%@ include file="./inc/viewKomaFooter.jsp" %>
			</div>
		<% } else {%>
			<% editTargetKoma = p; %>
			<div id="makeKomaDiv" style="position:relative">
				<div id="makeKomaShutter" class="whiteShutter" style="display:none;">&nbsp;</div>
				<%@ include file="./inc/makeKoma.jsp" %>
			</div>
			<br/>
		<% } %>
		
	</logic:iterate>
	
	<%@ include file="./inc/viewComicPager.jsp" %>
	<%@ include file="./inc/usrComicPager.jsp" %>

	<% if( 作成 ){ %>
		<% if( editSeqNO == null || editSeqNO.equals(0) ){ %>
			<%--★スペース★--%><div style="clear:both;height:40px;">&nbsp;</div>
			<div id="makeKomaDiv" style="position:relative">
				<div id="makeKomaShutter" class="whiteShutter" style="display:none;">&nbsp;</div>
				<%@ include file="./inc/makeKoma.jsp" %>
			</div>
		<% }  %>
		<%@ include file="./inc/画像選択パネル.jsp" %>
	<% } %>
	
	
	<%if( !"1".equals(previewFlg) ){%>
	
		<%--★スペース★--%><div style="height:20px;">&nbsp;</div>
		
		<logic:equal name="comic" property="type" value="U">
		
			<%--★スペース★--%><div style="clear:both;height:20px;">&nbsp;</div>
			<a href="<html:rewrite page="<%="/usr" + author.getUsrID()%>"/>"><b style="font-size:20pt;"><bean:write name="author" property="usrName"/>さんのページに戻る</b></a>
			
			<div style="text-align:right">
				ページビュー：<b><bean:write name="pageAuthor" property="pageView"/></b>
			</div>
			
		</logic:equal>
		<%--★スペース★--%><div style="height:20px;">&nbsp;</div>
		<div style="<%=(noHeaderFooter)?"display:none;":""%>">
			<hr style=""/>
			<a href="<bean:message key="link.top" bundle="depEnv"/>">トップページへ</a>
			<%--★スペース★--%><div id="pageHeightAdjuster" style="clear:both;height:20px;">&nbsp;</div>
		</div>
		
	<%}%>
	
</div>

<logic:notEqual name="comic" property="type" value="U">
	<%@ include file="./inc/makeBodyFooter.jsp" %>
</logic:notEqual>

<script>

var id = null
<logic:iterate id="p" name="pages" type="Koma" indexId="i">
	id = '<bean:write name="p" property="seqNO" />'
	if( $(id) ) $(id).JSObj = <%= p.getJSON() %>
</logic:iterate>

function checkComeOnSubmit(){
	if( $F('come') == "" ){
		alert('コメントが空です。') 
		return false
	}
	$('commentSubmit').disabled = true
	return true
}

function goPrevious( goTopFlg ){
	if( goTopFlg ){
		location.href = '/'
		return false
	}
	location.href = '<html:rewrite page="<%=goPrevious%>"/>'
	return false
}

</script>
<%@ include file="./inc/googleAnalytics.jsp" %>
</body>
<%@ include file="./js_jsp/view.js" %>
</html:html>