/*
 * Created on 12-Nov-2004
 *
 */
package versioncheck;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

/**
 * @author max
 *
 */
public class VersionCheckTask extends Task {

	private File file;
	private List filesets = new ArrayList();
	private File output;
	
	public void setVersionFile(File file) {
		this.file = file;		
	}
	
	public File getVersionFile() {
		return file;
	}
	
	public void setOutput(File file) {
		output=file;
	}
	
	public void addFileSet(FileSet fileset) {
		filesets.add(fileset);
	}
	
	void logWarn(String message) {
		log(message, Project.MSG_WARN);
	}
	
	public void execute() throws BuildException {
		try {
			boolean failed = false;
			StringWriter result = new StringWriter();
			PrintWriter writer = new PrintWriter(result);
			Properties props = new Properties();
			props.load(new FileInputStream(file));
			
			Set set = locateLibraryKeys(props);
			
			List availableLibraries = getAvailableLibraries();
			
			Iterator iterator = set.iterator();

			// check if all keys has their lib available...
			while (iterator.hasNext()) {
				String name = (String) iterator.next();
				String key =  name + ".lib";
				String library = props.getProperty(key);
				
				if(availableLibraries.remove(library)) {
					writer.println();
					writer.println(props.getProperty(key) + " (" + props.getProperty(name + ".version","unknown") +")");
					writer.println("- " + props.getProperty(name + ".name", "unknown name"));
					writer.println("- " + props.getProperty(name + ".when", "unknown requirement"));
					// a-ok ...we found it 
				} else {
					if(!Boolean.valueOf((String) props.getProperty(name + ".ignorecheck")).booleanValue()) {
						// 	otherwise: complain
						logWarn(library + " not found in fileset of libraries!");
						failed = true;
					}
				}
			}


			iterator = availableLibraries.iterator();
			// report about libraries not mentioned in properties file!
			while(iterator.hasNext()) {
				String leftover = (String) iterator.next();
				
				logWarn("Library " + leftover + " not listed in " + file);
				failed = true;
			}
			
			
			
			if(failed) throw new BuildException("Warning/Errors found during versioncheck.");
			
			if(output!=null) {
				FileWriter stream = new FileWriter(output);
				stream.write(result.getBuffer().toString());
				stream.flush();
				log("Wrote info file to " + output);
			}
			
		} catch (FileNotFoundException e) {
			throw new BuildException("Problems when loading " + file,e);
		} catch (IOException e) {
			throw new BuildException("Problems when loading " + file,e);
		}
		
		
		super.execute();
	}

	private List getAvailableLibraries() {
		List l = new java.util.ArrayList();
		// deal with the filesets
		for (int i = 0; i < filesets.size(); i++) {
			FileSet fs = (FileSet) filesets.get(i);
			DirectoryScanner ds = fs.getDirectoryScanner(getProject());
			String[] files = ds.getIncludedFiles();
			for (int j = 0; j < files.length; j++) {
				l.add( files[j]);                    
			}
		}
		
		//System.out.println("Available libraries:" + l); 
		return l;
	}

	/**
	 * @param props
	 * @return
	 */
	private Set locateLibraryKeys(Properties props) {
		Set libraries = new HashSet();
		Iterator iterator = props.keySet().iterator();
		while (iterator.hasNext()) {
			String key = (String) iterator.next();
			if(key.endsWith(".lib")) {
				String libname = key.substring(0,key.length()-4);
				if(!libraries.add(libname)) {
					logWarn(libname + " defined multiple times!");
				}
			}
		}
		return libraries;
	}
}
