/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.commands.UnauthorizedActionException;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.config.ActionConfig;

public abstract class AbstractAuthorizeAction
extends ActionCommandBase {
    private static final Log LOG = LogFactory.getLog((Class)AbstractAuthorizeAction.class);

    public boolean execute(ActionContext actionCtx) throws Exception {
        boolean throwEx;
        ActionConfig actionConfig = actionCtx.getActionConfig();
        if (!this.isAuthorizationRequired(actionConfig)) {
            return false;
        }
        try {
            throwEx = !this.isAuthorized(actionCtx, actionConfig.getRoleNames(), actionConfig);
        }
        catch (Exception ex) {
            throwEx = true;
            LOG.error((Object)"Unable to complete authorization process", (Throwable)ex);
        }
        if (throwEx) {
            throw new UnauthorizedActionException(this.getErrorMessage(actionCtx, actionConfig));
        }
        return false;
    }

    protected boolean isAuthorizationRequired(ActionConfig actionConfig) {
        String[] roles = actionConfig.getRoleNames();
        return roles != null && roles.length > 0;
    }

    protected abstract boolean isAuthorized(ActionContext var1, String[] var2, ActionConfig var3) throws Exception;

    protected abstract String getErrorMessage(ActionContext var1, ActionConfig var2);
}

