/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import org.jboss.util.MuNumber;
import org.jboss.util.NotCoercibleException;

public class MuInteger
extends MuNumber {
    private int value;

    public MuInteger() {
    }

    public MuInteger(int i) {
        this.value = i;
    }

    public MuInteger(Object obj) {
        this.setValue(obj);
    }

    public boolean commit(int assumed, int i) {
        boolean success;
        boolean bl = success = assumed == this.value;
        if (success) {
            this.value = i;
        }
        return success;
    }

    public int swap(MuInteger i) {
        if (i == this) {
            return i.value;
        }
        int temp = this.value;
        this.value = i.value;
        i.value = temp;
        return this.value;
    }

    public int increment() {
        return ++this.value;
    }

    public int decrement() {
        return --this.value;
    }

    public int add(int amount) {
        return this.value += amount;
    }

    public int subtract(int amount) {
        return this.value -= amount;
    }

    public int multiply(int factor) {
        return this.value *= factor;
    }

    public int divide(int factor) {
        return this.value /= factor;
    }

    public int negate() {
        this.value = -this.value;
        return this.value;
    }

    public int complement() {
        this.value ^= 0xFFFFFFFF;
        return this.value;
    }

    public int and(int b) {
        this.value &= b;
        return this.value;
    }

    public int or(int b) {
        this.value |= b;
        return this.value;
    }

    public int xor(int b) {
        this.value ^= b;
        return this.value;
    }

    public int shiftRight(int bits) {
        this.value >>= bits;
        return this.value;
    }

    public int shiftRightZero(int bits) {
        this.value >>>= bits;
        return this.value;
    }

    public int shiftLeft(int bits) {
        this.value <<= bits;
        return this.value;
    }

    public int compareTo(int other) {
        return this.value < other ? -1 : (this.value == other ? 0 : 1);
    }

    public int compareTo(Object obj) {
        return this.compareTo((MuInteger)obj);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            return this.value == ((MuInteger)obj).intValue();
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public void setValue(Object obj) {
        if (!(obj instanceof Number)) {
            throw new NotCoercibleException("can not convert to 'int': " + obj);
        }
        this.value = ((Number)obj).intValue();
    }

    public Object getValue() {
        return new Integer(this.value);
    }
}

