/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.logicalcobwebs.concurrent.WriterPreferenceReadWriteLock;
import org.logicalcobwebs.logging.Log;
import org.logicalcobwebs.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionInfoIF;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ProxyConnection;
import org.logicalcobwebs.proxool.ProxyConnectionIF;
import org.logicalcobwebs.proxool.ProxyFactory;

abstract class AbstractProxyConnection
implements ProxyConnectionIF {
    static final int STATUS_FORCE = -1;
    private WriterPreferenceReadWriteLock statusReadWriteLock = new WriterPreferenceReadWriteLock();
    private static final Log LOG = LogFactory.getLog(class$org$logicalcobwebs$proxool$AbstractProxyConnection == null ? (class$org$logicalcobwebs$proxool$AbstractProxyConnection = AbstractProxyConnection.class$("org.logicalcobwebs.proxool.AbstractProxyConnection")) : class$org$logicalcobwebs$proxool$AbstractProxyConnection);
    private Connection connection;
    private String delegateUrl;
    private int mark;
    private String reasonForMark;
    private int status;
    private long id;
    private Date birthDate;
    private long timeLastStartActive;
    private long timeLastStopActive;
    private ConnectionPool connectionPool;
    private String requester;
    private Set openStatements = new HashSet();
    private DecimalFormat idFormat = new DecimalFormat("0000");
    private boolean needToReset = false;
    static /* synthetic */ Class class$org$logicalcobwebs$proxool$AbstractProxyConnection;

    protected AbstractProxyConnection(Connection connection, long id, String delegateUrl, ConnectionPool connectionPool, int status) throws SQLException {
        this.connection = connection;
        this.delegateUrl = delegateUrl;
        this.setId(id);
        this.connectionPool = connectionPool;
        this.setBirthTime(System.currentTimeMillis());
        this.status = status;
        if (status == 2) {
            this.setTimeLastStartActive(System.currentTimeMillis());
        }
        connectionPool.initialiseConnectionResetter(connection);
        if (connection == null) {
            throw new SQLException("Unable to create new connection");
        }
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj instanceof ProxyConnection) {
                return this.connection.hashCode() == ((ProxyConnection)obj).getConnection().hashCode();
            }
            if (obj instanceof Connection) {
                return this.connection.hashCode() == obj.hashCode();
            }
            return super.equals(obj);
        }
        return false;
    }

    public boolean isClosed() {
        return this.getStatus() != 2;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return ProxyFactory.getDatabaseMetaData(this.connection, this);
    }

    protected void setNeedToReset(boolean needToReset) {
        this.needToReset = needToReset;
    }

    protected ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    protected void addOpenStatement(Statement statement) {
        this.openStatements.add(statement);
    }

    public void registerClosedStatement(Statement statement) {
        if (this.openStatements.contains(statement)) {
            this.openStatements.remove(statement);
        } else {
            this.connectionPool.getLog().warn(this.connectionPool.displayStatistics() + " - #" + this.getId() + " registered a statement as closed which wasn't known to be open.");
        }
    }

    public void reallyClose() throws SQLException {
        try {
            this.connectionPool.registerRemovedConnection(this.getStatus());
            this.connection.close();
        }
        catch (Throwable t) {
            this.connectionPool.getLog().error("#" + this.idFormat.format(this.getId()) + " encountered errors during destruction: " + t);
        }
    }

    public boolean isReallyClosed() throws SQLException {
        if (this.connection == null) {
            return true;
        }
        return this.connection.isClosed();
    }

    public void close() throws SQLException {
        try {
            if (this.isMarkedForExpiry()) {
                if (this.connectionPool.getLog().isDebugEnabled()) {
                    this.connectionPool.getLog().debug("Closing connection quickly (without reset) because it's marked for expiry anyway");
                }
            } else {
                Statement[] statements = this.openStatements.toArray(new Statement[this.openStatements.size()]);
                for (int j = 0; j < statements.length; ++j) {
                    Statement statement = statements[j];
                    statement.close();
                    if (!this.connectionPool.getLog().isDebugEnabled()) continue;
                    this.connectionPool.getLog().debug("Closing statement " + Integer.toHexString(statement.hashCode()) + " automatically");
                }
                this.openStatements.clear();
                if (this.needToReset) {
                    if (!this.connectionPool.resetConnection(this.connection, "#" + this.getId())) {
                        this.connectionPool.removeProxyConnection(this, "it couldn't be reset", true, true);
                    }
                    this.needToReset = false;
                }
            }
            this.connectionPool.putConnection(this);
        }
        catch (Throwable t) {
            this.connectionPool.getLog().error("#" + this.idFormat.format(this.getId()) + " encountered errors during closure: ", t);
        }
    }

    public int getMark() {
        return this.mark;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean setStatus(int newStatus) {
        return this.setStatus(-1, newStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setStatus(int oldStatus, int newStatus) {
        boolean success = false;
        try {
            this.statusReadWriteLock.writeLock().acquire();
            this.connectionPool.acquireConnectionStatusWriteLock();
            if (this.status == oldStatus || oldStatus == -1) {
                this.connectionPool.changeStatus(this.status, newStatus);
                this.status = newStatus;
                success = true;
                if (newStatus == oldStatus) {
                    LOG.warn("Unexpected attempt to change status from " + oldStatus + " to " + newStatus + ". Why would you want to do that?");
                } else if (newStatus == 2) {
                    this.setTimeLastStartActive(System.currentTimeMillis());
                } else if (oldStatus == 2) {
                    this.setTimeLastStopActive(System.currentTimeMillis());
                }
            }
        }
        catch (InterruptedException e) {
            LOG.error("Unable to acquire write lock for status");
        }
        finally {
            this.connectionPool.releaseConnectionStatusWriteLock();
            this.statusReadWriteLock.writeLock().release();
        }
        return success;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getBirthTime() {
        return this.birthDate.getTime();
    }

    public Date getBirthDate() {
        return this.birthDate;
    }

    public long getAge() {
        return System.currentTimeMillis() - this.getBirthTime();
    }

    public void setBirthTime(long birthTime) {
        this.birthDate = new Date(birthTime);
    }

    public long getTimeLastStartActive() {
        return this.timeLastStartActive;
    }

    public void setTimeLastStartActive(long timeLastStartActive) {
        this.timeLastStartActive = timeLastStartActive;
        this.setTimeLastStopActive(0L);
    }

    public long getTimeLastStopActive() {
        return this.timeLastStopActive;
    }

    public void setTimeLastStopActive(long timeLastStopActive) {
        this.timeLastStopActive = timeLastStopActive;
    }

    public String getRequester() {
        return this.requester;
    }

    public void setRequester(String requester) {
        this.requester = requester;
    }

    public boolean isNull() {
        return this.getStatus() == 0;
    }

    public boolean isAvailable() {
        return this.getStatus() == 1;
    }

    public boolean isActive() {
        return this.getStatus() == 2;
    }

    public boolean isOffline() {
        return this.getStatus() == 3;
    }

    public void markForExpiry(String reason) {
        this.mark = 1;
        this.reasonForMark = reason;
    }

    public boolean isMarkedForExpiry() {
        return this.getMark() == 1;
    }

    public String getReasonForMark() {
        return this.reasonForMark;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String toString() {
        return this.getId() + " is " + ConnectionPool.getStatusDescription(this.getStatus());
    }

    public String getDelegateUrl() {
        return this.delegateUrl;
    }

    public String getProxyHashcode() {
        return Integer.toHexString(this.hashCode());
    }

    public String getDelegateHashcode() {
        if (this.connection != null) {
            return Integer.toHexString(this.connection.hashCode());
        }
        return null;
    }

    public int compareTo(Object o) {
        return new Long(((ConnectionInfoIF)o).getId()).compareTo(new Long(this.getId()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

