/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.proxy;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.logicalcobwebs.asm.Type;
import org.logicalcobwebs.cglib.core.Block;
import org.logicalcobwebs.cglib.core.ClassEmitter;
import org.logicalcobwebs.cglib.core.CodeEmitter;
import org.logicalcobwebs.cglib.core.Constants;
import org.logicalcobwebs.cglib.core.EmitUtils;
import org.logicalcobwebs.cglib.core.ReflectUtils;
import org.logicalcobwebs.cglib.core.Signature;
import org.logicalcobwebs.cglib.core.TypeUtils;
import org.logicalcobwebs.cglib.proxy.CallbackGenerator;

class InvocationHandlerGenerator
implements CallbackGenerator {
    public static final InvocationHandlerGenerator INSTANCE = new InvocationHandlerGenerator();
    private static final Type INVOCATION_HANDLER = TypeUtils.parseType("org.logicalcobwebs.cglib.proxy.InvocationHandler");
    private static final Type UNDECLARED_THROWABLE_EXCEPTION = TypeUtils.parseType("org.logicalcobwebs.cglib.proxy.UndeclaredThrowableException");
    private static final Type METHOD = TypeUtils.parseType("java.lang.reflect.Method");
    private static final Signature INVOKE = TypeUtils.parseSignature("Object invoke(Object, java.lang.reflect.Method, Object[])");
    private static final Signature CSTRUCT_THROWABLE = TypeUtils.parseConstructor("Throwable");
    static /* synthetic */ Class class$java$lang$Exception;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$java$lang$RuntimeException;
    static /* synthetic */ Class class$java$lang$Error;

    InvocationHandlerGenerator() {
    }

    private String getFieldName(CallbackGenerator.Context context, Method method) {
        return "CGLIB$$METHOD_" + context.getUniqueName(method);
    }

    public void generate(ClassEmitter ce, CallbackGenerator.Context context) {
        Iterator it = context.getMethods();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            String fieldName = this.getFieldName(context, method);
            ce.declare_field(26, fieldName, METHOD, null, null);
            CodeEmitter e = ce.begin_method(context.getModifiers(method), ReflectUtils.getSignature(method), ReflectUtils.getExceptionTypes(method), null);
            Block handler = e.begin_block();
            context.emitCallback(e, context.getIndex(method));
            e.load_this();
            e.getfield(fieldName);
            e.create_arg_array();
            e.invoke_interface(INVOCATION_HANDLER, INVOKE);
            e.unbox(Type.getType(method.getReturnType()));
            e.return_value();
            handler.end();
            Class<?>[] exceptionTypes = method.getExceptionTypes();
            HashSet exceptionSet = new HashSet(Arrays.asList(exceptionTypes));
            if (!exceptionSet.contains(class$java$lang$Exception == null ? InvocationHandlerGenerator.class$("java.lang.Exception") : class$java$lang$Exception) && !exceptionSet.contains(class$java$lang$Throwable == null ? InvocationHandlerGenerator.class$("java.lang.Throwable") : class$java$lang$Throwable)) {
                if (!exceptionSet.contains(class$java$lang$RuntimeException == null ? InvocationHandlerGenerator.class$("java.lang.RuntimeException") : class$java$lang$RuntimeException)) {
                    e.catch_exception(handler, Constants.TYPE_RUNTIME_EXCEPTION);
                    e.athrow();
                }
                if (!exceptionSet.contains(class$java$lang$Error == null ? InvocationHandlerGenerator.class$("java.lang.Error") : class$java$lang$Error)) {
                    e.catch_exception(handler, Constants.TYPE_ERROR);
                    e.athrow();
                }
                for (int i = 0; i < exceptionTypes.length; ++i) {
                    e.catch_exception(handler, Type.getType(exceptionTypes[i]));
                    e.athrow();
                }
                e.catch_exception(handler, Constants.TYPE_THROWABLE);
                e.new_instance(UNDECLARED_THROWABLE_EXCEPTION);
                e.dup_x1();
                e.swap();
                e.invoke_constructor(UNDECLARED_THROWABLE_EXCEPTION, CSTRUCT_THROWABLE);
                e.athrow();
            }
            e.end_method();
        }
    }

    public void generateStatic(CodeEmitter e, CallbackGenerator.Context context) {
        Iterator it = context.getMethods();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            EmitUtils.load_method(e, method);
            e.putfield(this.getFieldName(context, method));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

