/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.logicalcobwebs.asm.ClassReader;
import org.logicalcobwebs.cglib.core.ClassGenerator;
import org.logicalcobwebs.cglib.core.ClassNameReader;
import org.logicalcobwebs.cglib.core.CodeGenerationException;
import org.logicalcobwebs.cglib.core.DefaultGeneratorStrategy;
import org.logicalcobwebs.cglib.core.DefaultNamingPolicy;
import org.logicalcobwebs.cglib.core.GeneratorStrategy;
import org.logicalcobwebs.cglib.core.NamingPolicy;
import org.logicalcobwebs.cglib.core.Predicate;
import org.logicalcobwebs.cglib.core.ReflectUtils;

public abstract class AbstractClassGenerator
implements ClassGenerator {
    private static final Object NAME_KEY = new Object();
    private GeneratorStrategy strategy = DefaultGeneratorStrategy.INSTANCE;
    private NamingPolicy namingPolicy;
    private Source source;
    private ClassLoader classLoader;
    private String namePrefix;
    private Object key;
    private boolean useCache = true;

    protected AbstractClassGenerator(Source source) {
        this.source = source;
    }

    protected void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    protected final String getClassName() {
        return this.getClassName(this.getClassLoader());
    }

    private String getClassName(ClassLoader loader) {
        NamingPolicy np = this.namingPolicy != null ? this.namingPolicy : DefaultNamingPolicy.INSTANCE;
        final Set nameCache = this.getClassNameCache(loader);
        return np.getClassName(this.namePrefix, this.source.name, this.key, new Predicate(){

            public boolean evaluate(Object arg) {
                return nameCache.contains(arg);
            }
        });
    }

    private Set getClassNameCache(ClassLoader loader) {
        return (Set)((Map)this.source.cache.get(loader)).get(NAME_KEY);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setNamingPolicy(NamingPolicy namingPolicy) {
        this.namingPolicy = namingPolicy;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public void setStrategy(GeneratorStrategy strategy) {
        this.strategy = strategy;
    }

    protected ClassLoader getClassLoader() {
        ClassLoader t = this.classLoader;
        if (t == null) {
            t = this.getDefaultClassLoader();
        }
        if (t == null) {
            t = this.getClass().getClassLoader();
        }
        if (t == null) {
            throw new IllegalStateException("Cannot determine classloader");
        }
        return t;
    }

    protected abstract ClassLoader getDefaultClassLoader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object create(Object key) {
        try {
            Object instance = null;
            Source source = this.source;
            synchronized (source) {
                ClassLoader loader = this.getClassLoader();
                HashMap<Object, Object> cache2 = null;
                if (this.useCache) {
                    cache2 = (HashMap<Object, Object>)this.source.cache.get(loader);
                    if (cache2 != null) {
                        instance = cache2.get(key);
                    } else {
                        cache2 = new HashMap<Object, Object>();
                        cache2.put(NAME_KEY, new HashSet());
                        this.source.cache.put(loader, cache2);
                    }
                }
                if (instance == null) {
                    this.key = key;
                    byte[] b = this.strategy.generate(this);
                    String className = ClassNameReader.getClassName(new ClassReader(b));
                    this.getClassNameCache(loader).add(className);
                    instance = this.firstInstance(ReflectUtils.defineClass(className, b, loader));
                    if (this.useCache) {
                        cache2.put(key, instance);
                    }
                    return instance;
                }
            }
            return this.nextInstance(instance);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    protected abstract Object firstInstance(Class var1) throws Exception;

    protected abstract Object nextInstance(Object var1) throws Exception;

    protected static class Source {
        String name;
        Map cache = new WeakHashMap();

        public Source(String name) {
            this.name = name;
        }
    }
}

