/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.asm.util;

import org.logicalcobwebs.asm.Attribute;
import org.logicalcobwebs.asm.ClassAdapter;
import org.logicalcobwebs.asm.ClassVisitor;
import org.logicalcobwebs.asm.CodeVisitor;
import org.logicalcobwebs.asm.util.CheckCodeAdapter;

public class CheckClassAdapter
extends ClassAdapter {
    private boolean start;
    private boolean end;

    public CheckClassAdapter(ClassVisitor cv) {
        super(cv);
    }

    public void visit(int access, String name, String superName, String[] interfaces, String sourceFile) {
        if (this.start) {
            throw new IllegalStateException("visit must be called only once");
        }
        this.start = true;
        this.checkState();
        CheckClassAdapter.checkAccess(access, 198199);
        CheckCodeAdapter.checkInternalName(name, "class name");
        if (name.equals("java/lang/Object")) {
            if (superName != null) {
                throw new IllegalArgumentException("The super class name of the Object class must be 'null'");
            }
        } else {
            CheckCodeAdapter.checkInternalName(superName, "super class name");
        }
        if ((access & 0x200) != 0 && !superName.equals("java/lang/Object")) {
            throw new IllegalArgumentException("The super class name of interfaces must be 'java/lang/Object'");
        }
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                CheckCodeAdapter.checkInternalName(interfaces[i], "interface name at index " + i);
            }
        }
        this.cv.visit(access, name, superName, interfaces, sourceFile);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.checkState();
        CheckCodeAdapter.checkInternalName(name, "class name");
        if (outerName != null) {
            CheckCodeAdapter.checkInternalName(outerName, "outer class name");
        }
        if (innerName != null) {
            CheckCodeAdapter.checkIdentifier(innerName, "inner class name");
        }
        CheckClassAdapter.checkAccess(access, 1599);
        this.cv.visitInnerClass(name, outerName, innerName, access);
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        this.checkState();
        CheckClassAdapter.checkAccess(access, 196831);
        CheckCodeAdapter.checkIdentifier(name, "field name");
        CheckCodeAdapter.checkDesc(desc, false);
        if (value != null) {
            CheckCodeAdapter.checkConstant(value);
        }
        this.cv.visitField(access, name, desc, value, attrs);
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        this.checkState();
        CheckClassAdapter.checkAccess(access, 199999);
        CheckCodeAdapter.checkMethodIdentifier(name, "method name");
        CheckCodeAdapter.checkMethodDesc(desc);
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                CheckCodeAdapter.checkInternalName(exceptions[i], "exception name at index " + i);
            }
        }
        return new CheckCodeAdapter(this.cv.visitMethod(access, name, desc, exceptions, attrs));
    }

    public void visitAttribute(Attribute attr) {
        this.checkState();
        if (attr == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
    }

    public void visitEnd() {
        this.checkState();
        this.end = true;
        this.cv.visitEnd();
    }

    private void checkState() {
        if (!this.start) {
            throw new IllegalStateException("Cannot visit member before visit has been called.");
        }
        if (this.end) {
            throw new IllegalStateException("Cannot visit member after visitEnd has been called.");
        }
    }

    static void checkAccess(int access, int possibleAccess) {
        int abs;
        int pro;
        if ((access & ~possibleAccess) != 0) {
            throw new IllegalArgumentException("Invalid access flags: " + access);
        }
        int pub = (access & 1) != 0 ? 1 : 0;
        int pri = (access & 2) != 0 ? 1 : 0;
        int n = pro = (access & 4) != 0 ? 1 : 0;
        if (pub + pri + pro > 1) {
            throw new IllegalArgumentException("public private and protected are mutually exclusive: " + access);
        }
        int fin = (access & 0x10) != 0 ? 1 : 0;
        int n2 = abs = (access & 0x400) != 0 ? 1 : 0;
        if (fin + abs > 1) {
            throw new IllegalArgumentException("final and abstract are mutually exclusive: " + access);
        }
    }
}

