/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.PERF_TP;
import org.jgroups.stack.Protocol;

public class PerfTpTest {
    JChannel ch = null;
    PERF_TP tp = null;
    DataInputStream in = null;
    DataOutputStream out = null;

    public static void main(String[] args) {
        String props = null;
        int num_msgs = 1000;
        int size = 1000;
        String file_name = null;
        boolean write = true;
        for (int i = 0; i < args.length; ++i) {
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-num".equals(args[i])) {
                num_msgs = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-size".equals(args[i])) {
                size = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-file_name".equals(args[i])) {
                file_name = args[++i];
                continue;
            }
            if ("-write".equals(args[i])) {
                write = true;
                continue;
            }
            if ("-read".equals(args[i])) {
                write = false;
                continue;
            }
            PerfTpTest.help();
            return;
        }
        try {
            new PerfTpTest().start(props, num_msgs, size, file_name, write);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void help() {
        System.out.println("PerfTpTest [-help] [-props <properties>] [-num <num msgs>] [-size <msg size (in bytes)] [-file_name <filename>] [-write] [-read]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(String props, int num_msgs, int size, String file_name, boolean write) throws Exception {
        byte[] buf = new byte[size];
        if (file_name != null) {
            if (write) {
                this.out = new DataOutputStream(new FileOutputStream(file_name));
            } else {
                this.in = new DataInputStream(new FileInputStream(file_name));
            }
        }
        this.ch = new JChannel(props);
        this.ch.connect("demo");
        this.tp = PERF_TP.getInstance();
        Address local_addr = this.ch.getLocalAddress();
        Vector<Address> members = new Vector<Address>();
        members.add(local_addr);
        View view = new View(local_addr, 0L, members);
        this.ch.down(new Event(16));
        this.ch.down(new Event(6, view));
        if (write) {
            this.tp.setExpectedMessages(num_msgs);
            for (int i = 0; i < num_msgs; ++i) {
                Message msg = new Message(null, local_addr, buf);
                this.ch.send(msg);
                if (this.out != null) {
                    msg.writeTo(this.out);
                }
                if (i % 1000 != 0) continue;
                System.out.println("sent " + i + " messages");
            }
        } else {
            LinkedList<Message> msgs = new LinkedList<Message>();
            Vector protocols = this.ch.getProtocolStack().getProtocols();
            Protocol transport = (Protocol)protocols.lastElement();
            int i = 0;
            while (true) {
                Message msg = new Message();
                try {
                    msg.readFrom(this.in);
                    msgs.add(msg);
                }
                catch (EOFException eof) {
                    num_msgs = msgs.size();
                    System.out.println("read " + num_msgs + " msgs from file");
                    this.tp.setExpectedMessages(msgs.size());
                    Iterator it = msgs.iterator();
                    while (it.hasNext()) {
                        msg = (Message)it.next();
                        transport.up(new Event(1, msg));
                        if (++i % 10000 != 0) continue;
                        System.out.println("passed up " + i + " messages");
                    }
                    break;
                }
            }
        }
        PERF_TP msgs = this.tp;
        synchronized (msgs) {
            if (!this.tp.done()) {
                this.tp.wait();
            }
        }
        long total = this.tp.getTotalTime();
        double msgs_per_ms = (double)num_msgs / (double)total;
        double msgs_per_sec = msgs_per_ms * 1000.0;
        double time_per_msg = (double)total / (double)num_msgs;
        double usec_per_msg = time_per_msg * 1000.0;
        System.out.println("num_msgs = " + num_msgs + ", total_time = " + total + "ms");
        System.out.println("msgs/millisec = " + msgs_per_ms + ", msgs/sec = " + msgs_per_sec + "\ntime/msg = " + time_per_msg + " ms" + " (" + usec_per_msg + " usec/msg)");
        this.ch.close();
    }
}

