/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import EDU.oswego.cs.dl.util.concurrent.CyclicBarrier;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.util.Util;

public class ConnectStressTest
extends TestCase {
    static CyclicBarrier start_connecting = null;
    static CyclicBarrier connected = null;
    static CyclicBarrier received_all_views = null;
    static CyclicBarrier start_disconnecting = null;
    static CyclicBarrier disconnected = null;
    static final int NUM = 30;
    MyThread[] threads;
    static JChannel channel;
    static String groupname;
    static String props;

    public ConnectStressTest(String name) {
        super(name);
    }

    static void log(String msg) {
        System.out.println("-- [" + Thread.currentThread().getName() + "] " + msg);
    }

    public void testConcurrentJoins() throws Exception {
        start_connecting = new CyclicBarrier(31);
        connected = new CyclicBarrier(31);
        received_all_views = new CyclicBarrier(31);
        start_disconnecting = new CyclicBarrier(31);
        disconnected = new CyclicBarrier(31);
        channel = new JChannel(props);
        long start = System.currentTimeMillis();
        channel.connect(groupname);
        long stop = System.currentTimeMillis();
        ConnectStressTest.log(channel.getLocalAddress() + " connected in " + (stop - start) + " msecs (" + channel.getView().getMembers().size() + " members). VID=" + channel.getView().getVid());
        ConnectStressTest.assertEquals((int)channel.getView().getMembers().size(), (int)1);
        this.threads = new MyThread[30];
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i] = new MyThread(i);
            this.threads[i].start();
        }
        start_connecting.barrier();
        start = System.currentTimeMillis();
        try {
            connected.barrier();
            stop = System.currentTimeMillis();
            System.out.println("-- took " + (stop - start) + " msecs for all " + 30 + " threads to connect");
            received_all_views.barrier();
            stop = System.currentTimeMillis();
            System.out.println("-- took " + (stop - start) + " msecs for all " + 30 + " threads to see all views");
            int num_members = channel.getView().getMembers().size();
            System.out.println("*--* number of members connected: " + num_members + ", (expected: " + 31 + ')');
            ConnectStressTest.assertEquals((int)31, (int)num_members);
        }
        catch (Exception ex) {
            ConnectStressTest.fail((String)ex.toString());
        }
    }

    public void testConcurrentLeaves() throws Exception {
        start_disconnecting.barrier();
        long start = System.currentTimeMillis();
        disconnected.barrier();
        long stop = System.currentTimeMillis();
        System.out.println("-- took " + (stop - start) + " msecs for " + 30 + " threads to disconnect");
        int num_members = 0;
        for (int i = 0; i < 10; ++i) {
            Vector mbrs;
            View v = channel.getView();
            Vector vector = mbrs = v != null ? v.getMembers() : null;
            if (mbrs != null) {
                num_members = mbrs.size();
                System.out.println("*--* number of members connected: " + num_members + ", (expected: 1)");
                if (num_members <= 1) break;
            }
            Util.sleep(500L);
        }
        ConnectStressTest.assertEquals((int)1, (int)num_members);
        channel.close();
    }

    public static Test suite() {
        TestSuite s = new TestSuite();
        s.addTest((Test)new ConnectStressTest("testConcurrentJoins"));
        s.addTest((Test)new ConnectStressTest("testConcurrentLeaves"));
        return s;
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{ConnectStressTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    static {
        groupname = "ConcurrentTestDemo";
        props = "UDP(mcast_addr=228.8.8.9;mcast_port=7788;ip_ttl=1;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=3000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=300,600,1200,2400,4800):UNICAST(timeout=300,600,1200,2400):pbcast.STABLE(desired_avg_gossip=5000):FRAG(frag_size=4096;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=false)";
    }

    public static class MyThread
    extends Thread {
        int index = -1;
        long total_connect_time = 0L;
        long total_disconnect_time = 0L;
        Address my_addr = null;

        public MyThread(int i) {
            super("thread #" + i);
            this.index = i;
        }

        public void run() {
            JChannel ch = null;
            try {
                ch = new JChannel(props);
                start_connecting.barrier();
                long start = System.currentTimeMillis();
                ch.connect(groupname);
                long stop = System.currentTimeMillis();
                this.total_connect_time = stop - start;
                View view = ch.getView();
                this.my_addr = ch.getLocalAddress();
                ConnectStressTest.log(this.my_addr + " connected in " + this.total_connect_time + " msecs (" + view.getMembers().size() + " members). VID=" + view.getVid());
                connected.barrier();
                int num_members = 0;
                while ((num_members = ch.getView().getMembers().size()) < 31) {
                    ConnectStressTest.log("num_members=" + num_members);
                    Util.sleep(2000L);
                }
                ConnectStressTest.log("reached " + num_members + " members");
                received_all_views.barrier();
                start_disconnecting.barrier();
                start = System.currentTimeMillis();
                ch.close();
                stop = System.currentTimeMillis();
                ConnectStressTest.log(this.my_addr + " disconnected in " + (stop - start) + " msecs");
                disconnected.barrier();
            }
            catch (BrokenBarrierException e) {
                e.printStackTrace();
            }
            catch (ChannelException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

