/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.ring;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.TreeSet;
import org.jgroups.Address;

public class RingToken
implements Externalizable {
    public static final int OPERATIONAL = 0;
    public static final int RECOVERY = 1;
    private int type = -1;
    private long tokenSeq;
    private long seq;
    private long aru;
    private int fcc;
    private int backlog;
    private int windowSize;
    private int windowThreshold;
    private Address aruId;
    private Collection retransmissionRequests;
    private Collection recoveredMembers;

    public RingToken() {
        this(0);
    }

    public RingToken(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Illegal Ring type");
        }
        this.type = type;
        this.initToken();
    }

    private void initToken() {
        this.retransmissionRequests = new TreeSet();
    }

    public void setAruId(Address address) {
        this.aruId = address;
    }

    public Address getAruId() {
        return this.aruId;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Illegal Ring type");
        }
        this.type = type;
    }

    public long getTokenSequence() {
        return this.tokenSeq;
    }

    public void incrementTokenSequence() {
        ++this.tokenSeq;
    }

    public long getHighestSequence() {
        return this.seq;
    }

    public void setHighestSequence(long highestSequence) {
        if (this.seq > highestSequence) {
            throw new IllegalArgumentException("Can not set highest sequence to be lower than current higest sequence " + this.seq);
        }
        this.seq = highestSequence;
    }

    public long getAllReceivedUpto() {
        return this.aru;
    }

    public void setAllReceivedUpto(long aru) {
        this.aru = aru;
        if (aru > this.seq) {
            this.seq = aru;
        }
    }

    public int getLastRoundBroadcastCount() {
        return this.fcc;
    }

    public void addLastRoundBroadcastCount(int transmitCount) {
        this.fcc += transmitCount;
        if (this.fcc < 0) {
            this.fcc = 0;
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void addBacklog(int back) {
        this.backlog += back;
        if (this.backlog < 0) {
            this.backlog = 0;
        }
    }

    public void setWindowSize(int newSize) {
        this.windowSize = newSize < 0 ? 0 : newSize;
    }

    public void addRecoveredMember(Address member) {
        if (this.recoveredMembers == null) {
            this.recoveredMembers = new TreeSet();
        }
        this.recoveredMembers.add(member);
    }

    public Collection getRecoveredMembers() {
        return this.recoveredMembers;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowThreshold(int newSize) {
        this.windowThreshold = newSize < 0 ? 0 : newSize;
    }

    public int getWindowThreshold() {
        return this.windowThreshold;
    }

    public Collection getRetransmissionRequests() {
        return this.retransmissionRequests;
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeLong(this.tokenSeq);
        oo.writeLong(this.seq);
        oo.writeInt(this.type);
        oo.writeLong(this.aru);
        oo.writeInt(this.fcc);
        oo.writeInt(this.backlog);
        oo.writeInt(this.windowSize);
        oo.writeInt(this.windowThreshold);
        oo.writeObject(this.aruId);
        oo.writeObject(this.retransmissionRequests);
        oo.writeObject(this.recoveredMembers);
    }

    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        this.tokenSeq = oi.readLong();
        this.seq = oi.readLong();
        this.type = oi.readInt();
        this.aru = oi.readLong();
        this.fcc = oi.readInt();
        this.backlog = oi.readInt();
        this.windowSize = oi.readInt();
        this.windowThreshold = oi.readInt();
        this.aruId = (Address)oi.readObject();
        this.retransmissionRequests = (Collection)oi.readObject();
        this.recoveredMembers = (Collection)oi.readObject();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(200);
        buf.append("Token[tokenSeq=").append(this.tokenSeq);
        buf.append(",type=").append(this.type);
        buf.append(",highestseq=").append(this.seq);
        buf.append(",aru=").append(this.aru);
        buf.append(",lastRoundTransmitCount=").append(this.fcc);
        buf.append(",backlog=").append(this.backlog);
        buf.append(",windowSize=").append(this.windowSize);
        buf.append(",windowThreshold=").append(this.windowThreshold);
        buf.append(",retransmissionList=").append(this.getRetransmissionRequests());
        buf.append(']');
        return buf.toString();
    }
}

