/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

class PerfEntry
implements Externalizable {
    long received = 0L;
    long done = 0L;
    long total = -1L;

    public long getReceived() {
        return this.received;
    }

    public long getDone() {
        return this.done;
    }

    public long getTotal() {
        return this.total;
    }

    public void setReceived(long r) {
        this.received = r;
    }

    public void setDone(long d) {
        this.done = d;
        if (this.received > 0L && this.done > 0L && this.done >= this.received) {
            this.total = this.done - this.received;
        }
    }

    public String toString() {
        if (this.total >= 0L) {
            return "time: " + this.total;
        }
        return "time: n/a";
    }

    public String printContents(boolean detailed) {
        StringBuffer sb = new StringBuffer();
        if (detailed) {
            if (this.received > 0L) {
                sb.append("received=").append(this.received);
            }
            if (this.done > 0L) {
                if (this.received > 0L) {
                    sb.append(", ");
                }
                sb.append("done=").append(this.done);
            }
        }
        if (detailed && (this.received > 0L || this.done > 0L)) {
            sb.append(", ");
        }
        sb.append(this.toString());
        return sb.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.received);
        out.writeLong(this.done);
        out.writeLong(this.total);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.received = in.readLong();
        this.done = in.readLong();
        this.total = in.readLong();
    }
}

