/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.configuration.AbstractFileConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;

public class INIConfiguration
extends AbstractFileConfiguration {
    protected static final String COMMENT_CHARS = "#;";
    protected static final String SEPARATOR_CHARS = "=:";
    private static final String LINE_SEPARATOR = "\r\n";

    public INIConfiguration() {
    }

    public INIConfiguration(String filename) throws ConfigurationException {
        super(filename);
    }

    public INIConfiguration(File file) throws ConfigurationException {
        super(file);
    }

    public INIConfiguration(URL url) throws ConfigurationException {
        super(url);
    }

    public void save(Writer writer) throws ConfigurationException {
        PrintWriter pw = new PrintWriter(writer);
        Iterator iter = this.getSections().iterator();
        while (iter.hasNext()) {
            String section = (String)iter.next();
            pw.print("[");
            pw.print(section);
            pw.print("]");
            pw.print(LINE_SEPARATOR);
            Configuration values = this.subset(section);
            Iterator iterator = values.getKeys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = values.getString(key);
                pw.print(key);
                pw.print(" = ");
                pw.print(value);
                pw.print(LINE_SEPARATOR);
            }
            pw.print(LINE_SEPARATOR);
        }
    }

    public void load(Reader reader) throws ConfigurationException {
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            String line = bufferedReader.readLine();
            String section = "";
            while (line != null) {
                if (!this.isCommentLine(line = line.trim())) {
                    if (this.isSectionLine(line)) {
                        section = line.substring(1, line.length() - 1) + ".";
                    } else {
                        String key = "";
                        String value = "";
                        int index = line.indexOf("=");
                        if (index >= 0) {
                            key = section + line.substring(0, index);
                            value = line.substring(index + 1);
                        } else {
                            index = line.indexOf(":");
                            if (index >= 0) {
                                key = section + line.substring(0, index);
                                value = line.substring(index + 1);
                            } else {
                                key = section + line;
                            }
                        }
                        this.addProperty(key.trim(), value.trim());
                    }
                }
                line = bufferedReader.readLine();
            }
        }
        catch (IOException ioe) {
            throw new ConfigurationException(ioe.getMessage());
        }
    }

    protected boolean isCommentLine(String s) {
        if (s == null) {
            return false;
        }
        return s.length() < 1 || COMMENT_CHARS.indexOf(s.charAt(0)) >= 0;
    }

    protected boolean isSectionLine(String s) {
        if (s == null) {
            return false;
        }
        return s.startsWith("[") && s.endsWith("]");
    }

    public Set getSections() {
        TreeSet<String> sections = new TreeSet<String>();
        Iterator iter = this.getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            int index = key.indexOf(".");
            if (index < 0) continue;
            sections.add(key.substring(0, index));
        }
        return sections;
    }
}

