/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import twitter4j.Trend;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;
import twitter4j.http.Response;
import twitter4j.org.json.JSONArray;
import twitter4j.org.json.JSONException;
import twitter4j.org.json.JSONObject;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trends
extends TwitterResponse
implements Comparable<Trends> {
    private Date asOf;
    private Date trendAt;
    private Trend[] trends;
    private static final long serialVersionUID = -7151479143843312309L;

    @Override
    public int compareTo(Trends that) {
        return this.trendAt.compareTo(that.trendAt);
    }

    Trends(Response res, Date asOf, Date trendAt, Trend[] trends) throws TwitterException {
        super(res);
        this.asOf = asOf;
        this.trendAt = trendAt;
        this.trends = trends;
    }

    static List<Trends> constructTrendsList(Response res) throws TwitterException {
        JSONObject json = res.asJSONObject();
        try {
            Date asOf = Trends.parseDate(json.getString("as_of"));
            JSONObject trendsJson = json.getJSONObject("trends");
            ArrayList<Trends> trends = new ArrayList<Trends>(trendsJson.length());
            Iterator ite = trendsJson.keys();
            while (ite.hasNext()) {
                String key = (String)ite.next();
                JSONArray array = trendsJson.getJSONArray(key);
                Trend[] trendsArray = Trends.jsonArrayToTrendArray(array);
                if (key.length() == 19) {
                    trends.add(new Trends(res, asOf, Trends.parseDate(key, "yyyy-MM-dd HH:mm:ss"), trendsArray));
                    continue;
                }
                if (key.length() == 16) {
                    trends.add(new Trends(res, asOf, Trends.parseDate(key, "yyyy-MM-dd HH:mm"), trendsArray));
                    continue;
                }
                if (key.length() != 10) continue;
                trends.add(new Trends(res, asOf, Trends.parseDate(key, "yyyy-MM-dd"), trendsArray));
            }
            Collections.sort(trends);
            return trends;
        }
        catch (JSONException jsone) {
            throw new TwitterException(new StringBuffer().append(jsone.getMessage()).append(":").append(res.asString()).toString(), jsone);
        }
    }

    static Trends constructTrends(Response res) throws TwitterException {
        JSONObject json = res.asJSONObject();
        try {
            Date asOf = Trends.parseDate(json.getString("as_of"));
            JSONArray array = json.getJSONArray("trends");
            Trend[] trendsArray = Trends.jsonArrayToTrendArray(array);
            return new Trends(res, asOf, asOf, trendsArray);
        }
        catch (JSONException jsone) {
            throw new TwitterException(new StringBuffer().append(jsone.getMessage()).append(":").append(res.asString()).toString(), jsone);
        }
    }

    private static Date parseDate(String asOfStr) throws TwitterException {
        Date parsed = asOfStr.length() == 10 ? new Date(Long.parseLong(asOfStr) * 1000L) : TwitterResponse.parseDate(asOfStr, "EEE, d MMM yyyy HH:mm:ss z");
        return parsed;
    }

    private static Trend[] jsonArrayToTrendArray(JSONArray array) throws JSONException {
        Trend[] trends = new Trend[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            JSONObject trend = array.getJSONObject(i);
            trends[i] = new Trend(trend);
        }
        return trends;
    }

    public Trend[] getTrends() {
        return this.trends;
    }

    public Date getAsOf() {
        return this.asOf;
    }

    public Date getTrendAt() {
        return this.trendAt;
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((Trends)x0);
    }
}

