/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.coding.BlockFrame;
import com.puppycrawl.tools.checkstyle.checks.coding.ClassFrame;
import com.puppycrawl.tools.checkstyle.checks.coding.FrameStack;
import com.puppycrawl.tools.checkstyle.checks.coding.LexicalFrame;
import com.puppycrawl.tools.checkstyle.checks.coding.MethodFrame;

public class RequireThisCheck
extends Check {
    private boolean mCheckFields = true;
    private boolean mCheckMethods = true;
    private FrameStack mFrames;

    public void setCheckFields(boolean aCheckFields) {
        this.mCheckFields = aCheckFields;
    }

    public boolean getCheckFields() {
        return this.mCheckFields;
    }

    public void setCheckMethods(boolean aCheckMethods) {
        this.mCheckMethods = aCheckMethods;
    }

    public boolean getCheckMethods() {
        return this.mCheckMethods;
    }

    public int[] getDefaultTokens() {
        return new int[]{58, 10, 21, 14, 9, 8, 7};
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void beginTree(DetailAST aRootAST) {
        this.mFrames = new FrameStack();
    }

    public void leaveToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 7: 
            case 8: 
            case 9: 
            case 14: {
                this.mFrames.leave();
                break;
            }
            case 10: 
            case 21: 
            case 58: {
                break;
            }
            default: {
                this.log(aAST, "require.this.unexpected.leaving", (Object)new Integer(aAST.getType()));
            }
        }
    }

    public void visitToken(DetailAST aAST) {
        switch (aAST.getType()) {
            case 10: 
            case 21: {
                DetailAST nameAST = aAST.findFirstToken(58);
                this.mFrames.current().addName(nameAST.getText());
                break;
            }
            case 14: {
                DetailAST nameAST = aAST.findFirstToken(58);
                this.mFrames.current().addName(nameAST.getText());
                this.mFrames.enter(new ClassFrame());
                break;
            }
            case 7: {
                this.mFrames.enter(new BlockFrame());
                break;
            }
            case 8: 
            case 9: {
                this.mFrames.enter(new MethodFrame());
                break;
            }
            case 58: {
                this.processIDENT(aAST);
                break;
            }
            default: {
                this.log(aAST, "require.this.unexpected.visit", (Object)new Integer(aAST.getType()));
            }
        }
    }

    private void processIDENT(DetailAST aAST) {
        int parentType = aAST.getParent().getType();
        if (parentType == 27) {
            if (this.mCheckMethods) {
                this.log(aAST, "require.this.method", (Object)aAST.getText());
            }
            return;
        }
        if (!this.mCheckFields) {
            return;
        }
        if (parentType == 59 && aAST.getPreviousSibling() != null) {
            return;
        }
        if (parentType == 13 || parentType == 136) {
            return;
        }
        if (parentType == 10 || parentType == 8 || parentType == 9 || parentType == 14 || parentType == 21) {
            return;
        }
        String name = aAST.getText();
        LexicalFrame declared = this.mFrames.findFrame(name);
        if (declared == null) {
            this.log(aAST, "require.this.unfound.variable", (Object)name);
        } else if (declared instanceof ClassFrame) {
            this.log(aAST, "require.this.variable", (Object)name);
        }
    }
}

