/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.util.Hashtable;
import javax.management.MBeanServerInvocationHandler;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.system.ServiceControllerMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.StartupGroupMBean;
import org.jboss.system.server.ServerImplMBean;

public class StartupGroup
extends ServiceMBeanSupport
implements StartupGroupMBean,
NotificationListener {
    private ObjectName serviceControllerName;
    private ServiceControllerMBean serviceController;
    private NotificationGroupBarrier barrier;

    public ServiceControllerMBean getServiceController() {
        return this.serviceController;
    }

    public void setServiceController(ServiceControllerMBean serviceController) {
        this.serviceController = serviceController;
    }

    public ObjectName getServiceControllerName() {
        return this.serviceControllerName;
    }

    public void setServiceControllerName(ObjectName name) {
        this.serviceControllerName = name;
    }

    public void handleNotification(Notification msg, Object handback) {
        String type = msg.getType();
        if (type.equals("org.jboss.system.server.started")) {
            this.log.debug((Object)("Saw " + type + " notification, starting barrier"));
            try {
                this.serviceController.create(this.barrier.getName());
                this.serviceController.start(this.barrier.getName());
            }
            catch (Throwable e) {
                this.log.warn((Object)"Failed to create/start barrier service", e);
            }
        } else if (type.equals("org.jboss.system.server.stopped")) {
            this.log.debug((Object)("Saw " + type + " notification, stopping barrier"));
            try {
                this.serviceController.stop(this.barrier.getName());
                this.serviceController.destroy(this.barrier.getName());
            }
            catch (Throwable e) {
                this.log.warn((Object)"Failed to create/start barrier service", e);
            }
        }
    }

    protected void jbossInternalCreate() throws Exception {
        this.serviceController = (ServiceControllerMBean)MBeanServerInvocationHandler.newProxyInstance(this.server, this.serviceControllerName, ServiceControllerMBean.class, true);
        ObjectName name = this.getServiceName();
        Hashtable<String, String> props = name.getKeyPropertyList();
        props.put("barrier", "serverStartup");
        ObjectName barrierName = new ObjectName(name.getDomain(), props);
        this.barrier = new NotificationGroupBarrier(barrierName);
        this.server.registerMBean(this.barrier, barrierName);
        this.server.addNotificationListener(ServerImplMBean.OBJECT_NAME, this, null, null);
    }

    public void jbossInternalDestroy() {
        try {
            this.server.removeNotificationListener(ServerImplMBean.OBJECT_NAME, this);
            this.server.unregisterMBean(this.barrier.getName());
        }
        catch (Throwable e) {
            this.log.debug((Object)"Unexpected error during shutdown", e);
        }
    }

    public void startBarrier() {
        this.log.debug((Object)"Starting the barrier service");
        try {
            this.serviceController.start(this.barrier.getName());
        }
        catch (Throwable e) {
            this.log.warn((Object)"Failed to stop barrier service", e);
        }
    }

    public void stopBarrier() {
        this.log.debug((Object)"Stopping the barrier service");
        try {
            this.serviceController.stop(this.barrier.getName());
        }
        catch (Throwable e) {
            this.log.warn((Object)"Failed to stop barrier service", e);
        }
    }

    static class NotificationGroupBarrier
    implements NotificationGroupBarrierMBean {
        private ObjectName name;

        NotificationGroupBarrier(ObjectName name) {
            this.name = name;
        }

        ObjectName getName() {
            return this.name;
        }
    }

    static interface NotificationGroupBarrierMBean {
    }
}

