/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import org.jboss.deployment.DeploymentInfo;
import org.jboss.logging.Logger;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.server.Invocation;
import org.jboss.mx.server.MBeanInvoker;

public abstract class SubDeployerInterceptor
extends AbstractInterceptor {
    protected MBeanInvoker invoker;

    public SubDeployerInterceptor(MBeanInvoker invoker, String name) {
        super(name);
        super.setLogger(Logger.getLogger((String)name));
        this.invoker = invoker;
    }

    public MBeanInvoker getInvoker() {
        return this.invoker;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        String type = invocation.getType();
        if (type.equals("invoke")) {
            Object[] args = invocation.getArgs();
            Class retn = invocation.getReturnTypeClass();
            if (args.length == 1 && args[0] instanceof DeploymentInfo && retn == null) {
                String method = invocation.getName();
                DeploymentInfo di = (DeploymentInfo)args[0];
                if (method.equals("init")) {
                    return this.init(invocation, di);
                }
                if (method.equals("create")) {
                    return this.create(invocation, di);
                }
                if (method.equals("start")) {
                    return this.start(invocation, di);
                }
                if (method.equals("stop")) {
                    return this.stop(invocation, di);
                }
                if (method.equals("destroy")) {
                    return this.destroy(invocation, di);
                }
            }
        }
        return this.invokeNext(invocation);
    }

    protected Object invokeNext(Invocation invocation) throws Throwable {
        AbstractInterceptor next = invocation.nextInterceptor();
        if (next != null) {
            return next.invoke(invocation);
        }
        return invocation.dispatch();
    }

    protected Object init(Invocation invocation, DeploymentInfo di) throws Throwable {
        return this.invokeNext(invocation);
    }

    protected Object create(Invocation invocation, DeploymentInfo di) throws Throwable {
        return this.invokeNext(invocation);
    }

    protected Object start(Invocation invocation, DeploymentInfo di) throws Throwable {
        return this.invokeNext(invocation);
    }

    protected Object stop(Invocation invocation, DeploymentInfo di) throws Throwable {
        return this.invokeNext(invocation);
    }

    protected Object destroy(Invocation invocation, DeploymentInfo di) throws Throwable {
        return this.invokeNext(invocation);
    }
}

