/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.javaParser.compiler141;

import com.sun.tools.javac.v8.tree.Tree;
import com.sun.tools.javac.v8.tree.TreeInfo;
import com.sun.tools.javac.v8.util.Context;
import com.sun.tools.javac.v8.util.Convert;
import com.sun.tools.javac.v8.util.List;
import com.tombrus.javaParser.compiler141.UnifiedVisitor;
import com.tombrus.javaParser.compiler141.VisitorUtils;

public class Reproducer
extends UnifiedVisitor {
    private static TreeInfo treeInfo = TreeInfo.instance((Context)new Context());
    private Tree tree;
    private List trees;
    private String sep;
    private StringBuffer buf;
    private int minPos = Integer.MAX_VALUE;
    private int maxPos = Integer.MIN_VALUE;

    public void visitUnarySubs(Tree.Unary unary) {
        this.adjustMinMaxPos((Tree)unary);
        this.buf.append("(");
        String string = treeInfo.operatorName(unary.tag).toString();
        if (unary.tag <= 46) {
            this.buf.append(string);
            this.visitOneTree(unary.arg);
        } else if (unary.tag <= 49) {
            this.visitOneTree(unary.arg);
            this.buf.append(string);
        }
        this.buf.append("(");
    }

    public void visitBinarySubs(Tree.Binary binary) {
        this.adjustMinMaxPos((Tree)binary);
        this.buf.append("(");
        String string = treeInfo.operatorName(binary.tag).toString();
        this.visitOneTree(binary.lhs);
        this.buf.append(" " + string + " ");
        this.visitOneTree(binary.rhs);
        this.buf.append("(");
    }

    public Reproducer(Tree tree) {
        this.tree = tree;
    }

    public Reproducer(List list, String string) {
        this.trees = list;
        this.sep = string;
    }

    protected void visitOneList(List list, String string) {
        while (list != null && list.nonEmpty()) {
            this.visitOneTree((Tree)list.head);
            if (list.tail != null && list.tail.nonEmpty()) {
                this.buf.append(string);
            }
            list = list.tail;
        }
    }

    private void adjustMinMaxPos(Tree tree) {
        this.minPos = Math.min(tree.pos, this.minPos);
        this.maxPos = Math.max(tree.pos, this.maxPos);
    }

    public int getMinPos() {
        if (this.minPos == Integer.MAX_VALUE) {
            this.toString();
        }
        return this.minPos;
    }

    public int getMaxPos() {
        if (this.maxPos == Integer.MIN_VALUE) {
            this.toString();
        }
        return this.maxPos;
    }

    public String toString() {
        String string = null;
        this.buf = new StringBuffer();
        if (this.tree != null) {
            this.visitOneTree(this.tree);
            string = this.buf.toString();
        } else if (this.trees != null) {
            this.visitOneList(this.trees, this.sep);
            string = this.buf.toString();
        }
        this.buf = null;
        return string;
    }

    public String toString_extends() {
        String string = null;
        if (this.tree instanceof Tree.ClassDef) {
            this.buf = new StringBuffer();
            this.extendsToBuf((Tree.ClassDef)this.tree);
            string = this.buf.toString();
            this.buf = null;
        }
        return string;
    }

    public String toString_implements() {
        String string = null;
        if (this.tree instanceof Tree.ClassDef) {
            this.buf = new StringBuffer();
            this.implementsToBuf((Tree.ClassDef)this.tree);
            string = this.buf.toString();
            this.buf = null;
        }
        return string;
    }

    public void visitImportSubs(Tree.Import import_) {
        this.adjustMinMaxPos((Tree)import_);
        this.buf.append("import ");
        this.visitOneTree(import_.qualid);
        this.buf.append(";\n");
    }

    public void visitClassDefSubs(Tree.ClassDef classDef) {
        this.adjustMinMaxPos((Tree)classDef);
        this.buf.append(VisitorUtils.flagsToString(classDef.flags & 0xE19L));
        this.buf.append("class ");
        this.buf.append(classDef.name);
        this.buf.append(" ");
        this.extendsToBuf(classDef);
        this.implementsToBuf(classDef);
        this.buf.append("{\n");
        this.visitOneList(classDef.defs, "\n");
        this.buf.append("\n}\n");
    }

    public void extendsToBuf(Tree.ClassDef classDef) {
        this.adjustMinMaxPos((Tree)classDef);
        if (classDef.extending != null) {
            this.buf.append("extends ");
            this.visitOneTree(classDef.extending);
            this.buf.append(" ");
        }
    }

    public void implementsToBuf(Tree.ClassDef classDef) {
        this.adjustMinMaxPos((Tree)classDef);
        if (classDef.implementing != null && classDef.implementing.nonEmpty()) {
            this.buf.append((classDef.flags & 0x200L) == 0L ? "implements " : "extends ");
            this.visitOneList(classDef.implementing, ", ");
            this.buf.append(" ");
        }
    }

    public void visitMethodDefSubs(Tree.MethodDef methodDef) {
        this.adjustMinMaxPos((Tree)methodDef);
        this.visitOneTree(methodDef.restype);
        this.buf.append(methodDef.name.toString().equals("<init>") ? methodDef.sym.owner.name : methodDef.name);
        this.buf.append("(");
        this.visitOneList(methodDef.params, ",");
        this.buf.append(") ");
        if (methodDef.thrown.nonEmpty()) {
            this.buf.append("throws ");
            this.visitOneList(methodDef.thrown, ",");
        }
        if (methodDef.body != null) {
            this.buf.append(" {\n");
            this.visitOneTree((Tree)methodDef.body);
            this.buf.append("}\n");
        }
    }

    public void visitVarDefSubs(Tree.VarDef varDef) {
        this.adjustMinMaxPos((Tree)varDef);
        this.visitOneTree(varDef.vartype);
        this.buf.append(varDef.name);
        if (varDef.init != null) {
            this.buf.append(" = ");
            this.visitOneTree(varDef.init);
        }
    }

    public void visitSelectSubs(Tree.Select select) {
        this.adjustMinMaxPos((Tree)select);
        this.visitOneTree(select.selected);
        this.buf.append(".");
        this.buf.append(select.name);
    }

    public void visitIdentSubs(Tree.Ident ident) {
        this.adjustMinMaxPos((Tree)ident);
        this.buf.append(ident.name);
    }

    public void visitSkipSubs(Tree.Skip skip) {
        this.adjustMinMaxPos((Tree)skip);
    }

    public void visitBlockSubs(Tree.Block block) {
        this.adjustMinMaxPos((Tree)block);
        this.visitOneList(block.stats, ";\n");
        this.buf.append(";\n");
    }

    public void visitDoLoopSubs(Tree.DoLoop doLoop) {
        this.adjustMinMaxPos((Tree)doLoop);
        this.visitOneTree(doLoop.cond);
        this.visitOneTree(doLoop.body);
    }

    public void visitWhileLoopSubs(Tree.WhileLoop whileLoop) {
        this.adjustMinMaxPos((Tree)whileLoop);
        this.visitOneTree(whileLoop.cond);
        this.visitOneTree(whileLoop.body);
    }

    public void visitForLoopSubs(Tree.ForLoop forLoop) {
        this.adjustMinMaxPos((Tree)forLoop);
        this.visitOneList(forLoop.init, ",");
        this.visitOneTree(forLoop.cond);
        this.visitOneList(forLoop.step, ",");
        this.visitOneTree(forLoop.body);
    }

    public void visitLabelledSubs(Tree.Labelled labelled) {
        this.adjustMinMaxPos((Tree)labelled);
        this.visitOneTree(labelled.body);
    }

    public void visitSwitchSubs(Tree.Switch switch_) {
        this.adjustMinMaxPos((Tree)switch_);
        this.visitOneTree(switch_.selector);
        this.visitOneList(switch_.cases, "\n");
    }

    public void visitCaseSubs(Tree.Case case_) {
        this.adjustMinMaxPos((Tree)case_);
        this.visitOneTree(case_.pat);
        this.visitOneList(case_.stats, ";\n");
    }

    public void visitSynchronizedSubs(Tree.Synchronized synchronized_) {
        this.adjustMinMaxPos((Tree)synchronized_);
        this.visitOneTree(synchronized_.lock);
        this.visitOneTree(synchronized_.body);
    }

    public void visitTrySubs(Tree.Try try_) {
        this.adjustMinMaxPos((Tree)try_);
        this.visitOneTree(try_.body);
        this.visitOneList(try_.catchers, ";\n");
        this.visitOneTree(try_.finalizer);
    }

    public void visitCatchSubs(Tree.Catch catch_) {
        this.adjustMinMaxPos((Tree)catch_);
        this.visitOneTree((Tree)catch_.param);
        this.visitOneTree(catch_.body);
    }

    public void visitConditionalSubs(Tree.Conditional conditional) {
        this.adjustMinMaxPos((Tree)conditional);
        this.visitOneTree(conditional.cond);
        this.visitOneTree(conditional.truepart);
        this.visitOneTree(conditional.falsepart);
    }

    public void visitIfSubs(Tree.If if_) {
        this.adjustMinMaxPos((Tree)if_);
        this.visitOneTree(if_.cond);
        this.visitOneTree(if_.thenpart);
        this.visitOneTree(if_.elsepart);
    }

    public void visitExecSubs(Tree.Exec exec) {
        this.adjustMinMaxPos((Tree)exec);
        this.visitOneTree(exec.expr);
    }

    public void visitBreakSubs(Tree.Break break_) {
        this.adjustMinMaxPos((Tree)break_);
    }

    public void visitContinueSubs(Tree.Continue continue_) {
        this.adjustMinMaxPos((Tree)continue_);
    }

    public void visitReturnSubs(Tree.Return return_) {
        this.adjustMinMaxPos((Tree)return_);
        this.visitOneTree(return_.expr);
    }

    public void visitThrowSubs(Tree.Throw throw_) {
        this.adjustMinMaxPos((Tree)throw_);
        this.visitOneTree(throw_.expr);
    }

    public void visitAssertSubs(Tree.Assert assert_) {
        this.adjustMinMaxPos((Tree)assert_);
        this.visitOneTree(assert_.cond);
        this.visitOneTree(assert_.detail);
    }

    public void visitApplySubs(Tree.Apply apply) {
        this.adjustMinMaxPos((Tree)apply);
        this.visitOneTree(apply.meth);
        this.buf.append("(");
        this.visitOneList(apply.args, ",");
        this.buf.append(")");
    }

    public void visitNewClassSubs(Tree.NewClass newClass) {
        this.adjustMinMaxPos((Tree)newClass);
        if (newClass.encl != null) {
            this.visitOneTree(newClass.encl);
            this.buf.append(".");
        }
        this.buf.append("new ");
        this.visitOneTree(newClass.clazz);
        this.buf.append("(");
        this.visitOneList(newClass.args, ",");
        this.buf.append(")");
        if (newClass.def != null) {
            this.visitOneTree((Tree)newClass.def);
        }
    }

    public void visitNewArraySubs(Tree.NewArray newArray) {
        this.adjustMinMaxPos((Tree)newArray);
        if (newArray.elemtype != null) {
            this.buf.append("new ");
            int n = 0;
            Tree tree = newArray.elemtype;
            while (tree.tag == 37) {
                ++n;
                tree = ((Tree.TypeArray)tree).elemtype;
            }
            this.visitOneTree(tree);
            List list = newArray.dims;
            while (list.nonEmpty()) {
                this.buf.append("[");
                this.visitOneTree((Tree)list.head);
                this.buf.append("]");
                list = list.tail;
            }
            int n2 = 0;
            while (n2 < n) {
                this.buf.append("[]");
                ++n2;
            }
            if (newArray.elems != null) {
                this.buf.append("[]");
            }
        }
        if (newArray.elems != null) {
            this.buf.append("{");
            this.visitOneList(newArray.elems, ",");
            this.buf.append("}");
        }
    }

    public void visitParensSubs(Tree.Parens parens) {
        this.adjustMinMaxPos((Tree)parens);
        this.visitOneTree(parens.expr);
    }

    public void visitAssignSubs(Tree.Assign assign) {
        this.adjustMinMaxPos((Tree)assign);
        this.visitOneTree(assign.lhs);
        this.buf.append(" = ");
        this.visitOneTree(assign.rhs);
    }

    public void visitAssignopSubs(Tree.Assignop assignop) {
        this.adjustMinMaxPos((Tree)assignop);
        this.visitOneTree(assignop.lhs);
        this.buf.append(assignop.operator);
        this.visitOneTree(assignop.rhs);
    }

    public void visitTypeCastSubs(Tree.TypeCast typeCast) {
        this.adjustMinMaxPos((Tree)typeCast);
        this.buf.append("(");
        this.buf.append("(");
        this.visitOneTree(typeCast.clazz);
        this.buf.append(")");
        this.visitOneTree(typeCast.expr);
        this.buf.append(")");
    }

    public void visitTypeTestSubs(Tree.TypeTest typeTest) {
        this.adjustMinMaxPos((Tree)typeTest);
        this.visitOneTree(typeTest.expr);
        this.visitOneTree(typeTest.clazz);
    }

    public void visitIndexedSubs(Tree.Indexed indexed) {
        this.adjustMinMaxPos((Tree)indexed);
        this.visitOneTree(indexed.indexed);
        this.buf.append("[");
        this.visitOneTree(indexed.index);
        this.buf.append("]");
    }

    public void visitLiteralSubs(Tree.Literal literal) {
        this.adjustMinMaxPos((Tree)literal);
        switch (literal.typetag) {
            case 4: {
                this.buf.append(literal.value.toString());
                break;
            }
            case 5: {
                this.buf.append(literal.value.toString() + "L");
                break;
            }
            case 6: {
                this.buf.append(literal.value.toString() + "F");
                break;
            }
            case 7: {
                this.buf.append(literal.value.toString());
                break;
            }
            case 2: {
                this.buf.append("'" + Convert.quote((String)String.valueOf((char)((Number)literal.value).intValue())) + "'");
                break;
            }
            case 10: {
                this.buf.append("\"" + Convert.quote((String)((String)literal.value)) + "\"");
                break;
            }
            default: {
                this.buf.append(literal.value.toString());
            }
        }
    }

    public void visitTypeIdentSubs(Tree.TypeIdent typeIdent) {
        this.adjustMinMaxPos((Tree)typeIdent);
        switch (typeIdent.typetag) {
            case 8: {
                this.buf.append("boolean ");
                break;
            }
            case 1: {
                this.buf.append("byte ");
                break;
            }
            case 2: {
                this.buf.append("char ");
                break;
            }
            case 7: {
                this.buf.append("double ");
                break;
            }
            case 6: {
                this.buf.append("float ");
                break;
            }
            case 4: {
                this.buf.append("int ");
                break;
            }
            case 5: {
                this.buf.append("long ");
                break;
            }
            case 3: {
                this.buf.append("short ");
                break;
            }
            case 9: {
                this.buf.append("void ");
                break;
            }
            default: {
                this.buf.append("<unknown typeTag " + typeIdent.typetag + "> ");
            }
        }
    }

    public void visitTypeArraySubs(Tree.TypeArray typeArray) {
        this.adjustMinMaxPos((Tree)typeArray);
        this.visitOneTree(typeArray.elemtype);
    }

    public void visitErroneousSubs(Tree.Erroneous erroneous) {
        this.adjustMinMaxPos((Tree)erroneous);
    }
}

