/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.javaParser.compiler140;

import com.sun.tools.javac.v8.code.Flags;
import com.sun.tools.javac.v8.code.Symbol;
import com.sun.tools.javac.v8.code.Type;
import com.sun.tools.javac.v8.tree.Tree;
import com.sun.tools.javac.v8.tree.TreeInfo;
import com.sun.tools.javac.v8.util.Convert;
import com.sun.tools.javac.v8.util.Hashtable;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.Name;
import com.sun.tools.javac.v8.util.Position;
import java.io.PrintStream;

public class Dumpy
extends Tree.Visitor
implements Flags {
    PrintStream out;
    public int width = 4;
    int lmargin = 0;
    Hashtable ends;

    public Dumpy(String string) {
        this(string, System.err);
    }

    public Dumpy(String string, PrintStream printStream) {
        this.out = printStream;
        this.print("+++++ " + string + " Tree Dump:");
        this.println();
    }

    public void dump(List list) {
        this.printList(list);
        this.println();
    }

    public void dump(Tree tree) {
        this.printTree(tree);
        this.println();
    }

    void align() {
        int n = 0;
        while (n < this.lmargin) {
            this.out.print(" ");
            ++n;
        }
    }

    void indent() {
        this.lmargin += this.width;
    }

    void undent() {
        this.lmargin -= this.width;
    }

    public void print(String string) {
        this.out.print(Convert.escapeUnicode((String)string));
    }

    public void println() {
        this.out.println();
    }

    public void printTree(Tree tree) {
        this.printTree("", tree);
    }

    public void printTree(String string, Tree tree) {
        if (tree != null) {
            this.println();
            this.align();
            this.print(string);
            this.print(" ");
            this.printLC(tree);
            this.indent();
            tree.visit((Tree.Visitor)this);
            this.undent();
        }
    }

    public void printList(List list) {
        this.printList("", list);
    }

    public void printList(String string, List list) {
        int n = 0;
        while (list != null && list.nonEmpty()) {
            this.printTree(string + "[" + n + "]", (Tree)list.head);
            ++n;
            list = list.tail;
        }
    }

    public void printName(Name name) {
        if (name != null) {
            this.print(name.toString());
        }
    }

    public void printSymb(Symbol symbol) {
        this.printSymb("", symbol);
    }

    public void printSymb(String string, Symbol symbol) {
        if (symbol != null) {
            this.println();
            this.align();
            this.print(string);
            this.print(" ");
            this.indent();
            this.print(this.getSubClassName(symbol) + " " + symbol.toJava() + " owner=" + symbol.owner);
            this.undent();
        }
    }

    public void printType(Type type) {
        this.printType("", type);
    }

    public void printType(String string, Type type) {
        if (type != null) {
            this.println();
            this.align();
            this.print(string);
            this.print(" ");
            this.indent();
            this.print(this.getSubClassName(type) + " " + type.toJava() + " ");
            this.undent();
        }
    }

    public static String getFlags(int n) {
        return ((n & 0x10000) != 0 ? "/*synthetic*/ " : "") + TreeInfo.flagNames((int)n) + " ";
    }

    public void printLC(Tree tree) {
        Integer n;
        String string = null;
        if (this.ends != null && (n = (Integer)this.ends.get((Object)tree)) != null) {
            string = this.makeLC(tree.pos, n);
        }
        if (string == null) {
            string = this.makeLC(tree.pos);
        }
        this.print("[" + this.getSubClassName(tree) + ":" + string + "] ");
    }

    public String makeLC(int n) {
        return Position.line((int)n) + "," + Position.column((int)n);
    }

    public String makeLC(int n, int n2) {
        if (Position.line((int)n) == Position.line((int)n2)) {
            return this.makeLC(n) + "..." + Position.column((int)n2);
        }
        return this.makeLC(n) + "..." + this.makeLC(n2);
    }

    public String getSubClassName(Object object) {
        String string = object.getClass().getName();
        int n = string.indexOf("$");
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return "#" + string + "#";
    }

    public void _case(Tree.TopLevel topLevel) {
        this.ends = topLevel.endPositions;
        this.printName(topLevel.sourcefile);
        this.printTree("pid          ", topLevel.pid);
        this.printSymb("packge-SYM   ", (Symbol)topLevel.packge);
        this.printList("defs      ", topLevel.defs);
        this.ends = null;
    }

    public void _case(Tree.Import import_) {
        this.printTree("qualid       ", import_.qualid);
    }

    public void _case(Tree.ClassDef classDef) {
        this.print(Dumpy.getFlags(classDef.flags) + classDef.name);
        this.printSymb("==SYM        ", (Symbol)classDef.sym);
        this.printType("==TYPE       ", classDef.type);
        this.printTree("extending    ", classDef.extending);
        this.printList("implementing ", classDef.implementing);
        this.printList("defs      ", classDef.defs);
    }

    public void _case(Tree.MethodDef methodDef) {
        this.print(Dumpy.getFlags(methodDef.flags) + methodDef.name);
        this.printSymb("==SYM        ", (Symbol)methodDef.sym);
        this.printType("==TYPE       ", methodDef.type);
        this.printTree("restype      ", methodDef.restype);
        this.printList("params       ", methodDef.params);
        this.printList("thrown       ", methodDef.thrown);
        this.printTree("body         ", (Tree)methodDef.body);
    }

    public void _case(Tree.VarDef varDef) {
        this.print(Dumpy.getFlags(varDef.flags) + varDef.name);
        this.printSymb("==SYM        ", (Symbol)varDef.sym);
        this.printTree("vartype      ", varDef.vartype);
        this.printTree("init         ", varDef.init);
    }

    public void _case(Tree.Skip skip) {
    }

    public void _case(Tree.Block block) {
        this.print(Dumpy.getFlags(block.flags) + "{}");
        this.printList("statements", block.stats);
    }

    public void _case(Tree.DoLoop doLoop) {
        this.printTree("cond         ", doLoop.cond);
        this.printTree("body         ", doLoop.body);
    }

    public void _case(Tree.WhileLoop whileLoop) {
        this.printTree("cond         ", whileLoop.cond);
        this.printTree("body         ", whileLoop.body);
    }

    public void _case(Tree.ForLoop forLoop) {
        this.printList("init         ", forLoop.init);
        this.printTree("cond         ", forLoop.cond);
        this.printList("step         ", forLoop.step);
        this.printTree("body         ", forLoop.body);
    }

    public void _case(Tree.Labelled labelled) {
        this.printName(labelled.label);
        this.printTree("body         ", labelled.body);
    }

    public void _case(Tree.Switch switch_) {
        this.printTree("selector     ", switch_.selector);
        this.printList("cases        ", switch_.cases);
    }

    public void _case(Tree.Case case_) {
        this.printTree("cpat         ", case_.pat);
        this.printList("stats        ", case_.stats);
    }

    public void _case(Tree.Synchronized synchronized_) {
        this.printTree("lock         ", synchronized_.lock);
        this.printTree("body         ", synchronized_.body);
    }

    public void _case(Tree.Try try_) {
        this.printTree("body         ", try_.body);
        this.printList("catchers     ", try_.catchers);
        this.printTree("finalizer    ", try_.finalizer);
    }

    public void _case(Tree.Catch catch_) {
        this.printTree("param        ", (Tree)catch_.param);
        this.printTree("body         ", catch_.body);
    }

    public void _case(Tree.Conditional conditional) {
        this.printTree("cond         ", conditional.cond);
        this.printTree("truepart     ", conditional.truepart);
        this.printTree("falsepart    ", conditional.falsepart);
    }

    public void _case(Tree.If if_) {
        this.printTree("cond         ", if_.cond);
        this.printTree("thenpart     ", if_.thenpart);
        this.printTree("elsepart     ", if_.elsepart);
    }

    public void _case(Tree.Exec exec) {
        this.printTree("expr         ", exec.expr);
    }

    public void _case(Tree.Break break_) {
        this.printName(break_.label);
    }

    public void _case(Tree.Continue continue_) {
        this.printName(continue_.label);
    }

    public void _case(Tree.Return return_) {
        this.printTree("expr         ", return_.expr);
    }

    public void _case(Tree.Throw throw_) {
        this.printTree("expr         ", throw_.expr);
    }

    public void _case(Tree.Assert assert_) {
        this.printTree("cond         ", assert_.cond);
        this.printTree("detail       ", assert_.detail);
    }

    public void _case(Tree.Apply apply) {
        this.printTree("meth         ", apply.meth);
        this.printList("args         ", apply.args);
    }

    public void _case(Tree.NewClass newClass) {
        this.printSymb("constr-SYM   ", newClass.constructor);
        this.printTree("encl         ", newClass.encl);
        this.printTree("clazz        ", newClass.clazz);
        this.printList("args         ", newClass.args);
        this.printTree("def          ", (Tree)newClass.def);
    }

    public void _case(Tree.NewArray newArray) {
        this.printTree("elemtype     ", newArray.elemtype);
        this.printList("dims         ", newArray.dims);
        this.printList("elems        ", newArray.elems);
    }

    public void _case(Tree.Parens parens) {
        this.printTree("expr         ", parens.expr);
    }

    public void _case(Tree.Assign assign) {
        this.printTree("lhs          ", assign.lhs);
        this.printTree("rhs          ", assign.rhs);
    }

    public void _case(Tree.Assignop assignop) {
        this.printName(TreeInfo.operatorName((int)(assignop.tag - 17)));
        this.printTree("lhs          ", assignop.lhs);
        this.printTree("rhs          ", assignop.rhs);
    }

    public void _case(Tree.Operation operation) {
        this.printName(TreeInfo.operatorName((int)operation.tag));
        this.printList("args         ", operation.args);
    }

    public void _case(Tree.TypeCast typeCast) {
        this.printTree("expr         ", typeCast.expr);
        this.printTree("clazz        ", typeCast.clazz);
    }

    public void _case(Tree.TypeTest typeTest) {
        this.printTree("expr         ", typeTest.expr);
        this.printTree("clazz        ", typeTest.clazz);
    }

    public void _case(Tree.Indexed indexed) {
        this.printTree("indexed      ", indexed.indexed);
        this.printTree("index        ", indexed.index);
    }

    public void _case(Tree.Select select) {
        this.printName(select.name);
        this.printSymb("==SYM        ", select.sym);
        this.printType("==TYPE       ", select.type);
        this.printTree("selected     ", select.selected);
    }

    public void _case(Tree.Ident ident) {
        this.printName(ident.name);
        this.printSymb("==SYM        ", ident.sym);
        this.printType("==TYPE       ", ident.type);
    }

    public void _case(Tree.Literal literal) {
        switch (literal.typetag) {
            case 4: {
                this.print(literal.value.toString());
                break;
            }
            case 5: {
                this.print(literal.value.toString() + "L");
                break;
            }
            case 6: {
                this.print(literal.value.toString() + "F");
                break;
            }
            case 7: {
                this.print(literal.value.toString());
                break;
            }
            case 2: {
                this.print("'" + Convert.quote((String)String.valueOf((char)((Number)literal.value).intValue())) + "'");
                break;
            }
            case 10: {
                this.print("\"" + Convert.quote((String)((String)literal.value)) + "\"");
                break;
            }
            default: {
                this.print(literal.value.toString());
            }
        }
    }

    public void _case(Tree.TypeIdent typeIdent) {
        this.printName(Type.typeOfTag[typeIdent.typetag].tsym.name);
    }

    public void _case(Tree.TypeArray typeArray) {
        this.printTree("elemtype     ", typeArray.elemtype);
    }

    public void _case(Tree.Erroneous erroneous) {
        this.print("(ERROR)");
    }

    public void _case(Tree tree) {
        this.print("(UNKNOWN: " + tree + ")");
    }
}

