/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.cleanImports.parser.compiler140;

import com.sun.tools.javac.v8.code.Flags;
import com.sun.tools.javac.v8.code.Scope;
import com.sun.tools.javac.v8.code.Symbol;
import com.sun.tools.javac.v8.code.Type;
import com.sun.tools.javac.v8.tree.Tree;
import com.sun.tools.javac.v8.util.List;
import com.sun.tools.javac.v8.util.Names;
import com.sun.tools.javac.v8.util.Position;
import com.tombrus.cleanImports.parser.Cleaner;
import com.tombrus.javaParser.ProgressKeeper;
import com.tombrus.javaParser.Span;
import com.tombrus.javaParser.SpanDoctor;
import com.tombrus.javaParser.Token;
import com.tombrus.javaParser.compiler140.VisitorUtils;
import com.tombrus.util.DB;
import com.tombrus.util.InternalProblem;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CleanerPass1
extends Tree.Visitor
implements Flags,
Runnable {
    public boolean DEBUG;
    private Cleaner cleaner;
    private ProgressKeeper progressKeeper;
    private List trees;
    private Set allScopes = new HashSet();
    private Tree.TopLevel currTopLevel;
    private String currClassName;
    private String currFullClassName;
    private Tree.ClassDef currClassDef;
    private SpanDoctor spanDoctor;
    private HashSet reportedVarDefs;

    public CleanerPass1(Cleaner cleaner, Object object, Object object2) {
        this.cleaner = cleaner;
        this.progressKeeper = (ProgressKeeper)object;
        this.trees = (List)object2;
    }

    public void run() {
        this.visitList(this.trees);
        Iterator iterator = this.allScopes.iterator();
        while (iterator.hasNext()) {
            Scope scope = (Scope)iterator.next();
            String string = scope.owner.fullName().toString();
            Set set = CleanerPass1.getClassSymbolsFromScope(scope);
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)iterator2.next();
                if (classSymbol.owner != scope.owner) continue;
                this.cleaner.packageContents(string, classSymbol.name.toString());
            }
        }
    }

    private static Set getClassSymbolsFromScope(Scope scope) {
        HashSet<Symbol> hashSet = new HashSet<Symbol>();
        Scope.Entry entry = scope.elems;
        while (entry != null) {
            if (entry.sym != null && entry.sym instanceof Symbol.ClassSymbol) {
                hashSet.add(entry.sym);
            }
            entry = entry.sibling;
        }
        return hashSet;
    }

    private void visitTree(Tree tree) {
        if (tree != null) {
            tree.visit((Tree.Visitor)this);
        }
    }

    private void visitList(List list) {
        while (list != null && list.nonEmpty()) {
            this.visitTree((Tree)list.head);
            list = list.tail;
        }
    }

    private SpanDoctor getSpanDoctor() {
        if (this.spanDoctor == null) {
            if (this.currTopLevel == null || this.currTopLevel.sourcefile == null) {
                throw new TreeProblem("spanDoctor required while no file.");
            }
            this.spanDoctor = new SpanDoctor(8, this.currTopLevel.sourcefile.toString(), new SpanDoctor.BugCorrector(){

                public void correctForCompilerBug(Token token) {
                    int n;
                    if ((token.type == 752 || token.type == 753) && token.to.column != token.from.column + (n = token.value.length())) {
                        token.to.column = token.from.column + n;
                    }
                }
            });
        }
        return this.spanDoctor;
    }

    private Span getNameSpan(Tree tree) throws TreeProblem {
        return this.getNameSpan(tree, this.getStringFromTree(tree));
    }

    private Span getNameSpan(Tree tree, String string) throws TreeProblem {
        int n = this.getPosFromTree(tree);
        return this.getSpanDoctor().getSpan(Position.line((int)n), Position.column((int)n), string);
    }

    private void classDependency(Tree tree) {
        if (tree != null) {
            try {
                if (tree instanceof Tree.Select) {
                    Tree.Select select = (Tree.Select)tree;
                    this.classDependency(tree, select.sym);
                } else if (tree instanceof Tree.Ident) {
                    Tree.Ident ident = (Tree.Ident)tree;
                    this.classDependency(tree, ident.sym);
                } else if (tree instanceof Tree.VarDef) {
                    Tree.VarDef varDef = (Tree.VarDef)tree;
                    this.classDependency(varDef.vartype);
                } else if (tree instanceof Tree.TypeArray) {
                    Tree.TypeArray typeArray = (Tree.TypeArray)tree;
                    this.classDependency(typeArray.elemtype);
                } else if (tree instanceof Tree.Parens) {
                    Tree.Parens parens = (Tree.Parens)tree;
                    this.classDependency(parens.expr);
                } else if (!(tree instanceof Tree.TypeIdent)) {
                    new TreeProblem("tree should be a Select/Ident/TypeIdent/TypeArray but it is " + tree.getClass() + ".").report();
                }
            }
            catch (TreeProblem treeProblem) {
                treeProblem.report();
            }
        }
    }

    private void classDependency(Tree tree, Symbol symbol) throws TreeProblem {
        if (symbol instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
            if (VisitorUtils.isVisibleFromTheOutside(symbol)) {
                String string = classSymbol.name.toString();
                String string2 = this.fullName((Symbol)classSymbol);
                String string3 = this.getPackageFromSymbol(classSymbol);
                String string4 = classSymbol.classfile == null ? null : classSymbol.classfile.getPath();
                this.cleaner.classDependency(this.currFullClassName, this.currClassName, string2, string, this.getStringFromTree(tree), string3, this.getNameSpan(tree), string4, this.noSuchType((Symbol)classSymbol));
                this.allScopes.add(classSymbol.owner.members());
            }
        } else {
            throw new TreeProblem("dependency on non-ClassSymbol: " + symbol.getClass() + ".");
        }
    }

    private int getPosFromTree(Tree tree) throws TreeProblem {
        final int[] nArray = new int[]{Integer.MAX_VALUE};
        tree.visit(new Tree.Visitor(){

            public void _case(Tree.Select select) {
                this.acceptBetter(select.pos);
                select.selected.visit((Tree.Visitor)this);
            }

            public void _case(Tree.Ident ident) {
                this.acceptBetter(ident.pos);
            }

            public void _case(Tree.ClassDef classDef) {
                this.acceptBetter(classDef.pos);
            }

            public void _case(Tree.Import import_) {
                this.acceptBetter(import_.pos);
            }

            public void _case(Tree.MethodDef methodDef) {
                this.acceptBetter(methodDef.pos);
            }

            public void _case(Tree.Parens parens) {
                this.acceptBetter(parens.pos);
                parens.expr.visit((Tree.Visitor)this);
            }

            private void acceptBetter(int n) {
                if (n < nArray[0]) {
                    nArray[0] = n;
                }
            }
        });
        if (nArray[0] == Integer.MAX_VALUE) {
            throw new TreeProblem("can not deduce correct span from " + tree);
        }
        return nArray[0];
    }

    private String getStringFromTree(Tree tree) throws TreeProblem {
        return this.getStringFromTree(tree, new StringBuffer()).toString();
    }

    private StringBuffer getStringFromTree(Tree tree, StringBuffer stringBuffer) throws TreeProblem {
        if (tree instanceof Tree.Ident) {
            Tree.Ident ident = (Tree.Ident)tree;
            stringBuffer.append(ident.name);
        } else if (tree instanceof Tree.Select) {
            Tree.Select select = (Tree.Select)tree;
            this.getStringFromTree(select.selected, stringBuffer).append(".").append(select.name);
        } else if (tree instanceof Tree.Import) {
            Tree.Import import_ = (Tree.Import)tree;
            this.getStringFromTree(import_.qualid, stringBuffer.append("import ")).append(";");
        } else if (tree instanceof Tree.Parens) {
            Tree.Parens parens = (Tree.Parens)tree;
            this.getStringFromTree(parens.expr, stringBuffer.append("(")).append(")");
        } else {
            throw new TreeProblem("tree should be a Select/Ident/Import but it is " + tree.getClass() + ".");
        }
        return stringBuffer;
    }

    private String fullName(Symbol symbol) {
        return symbol.fullName().toString();
    }

    private String getPackageFromSymbol(Symbol.ClassSymbol classSymbol) {
        String string = classSymbol.flatName().toString();
        int n = string.lastIndexOf(".");
        string = n == -1 ? "" : string.substring(0, n);
        return string;
    }

    private boolean noSuchType(Symbol symbol) {
        if (symbol instanceof Symbol.TypeSymbol) {
            Symbol.TypeSymbol typeSymbol = (Symbol.TypeSymbol)symbol;
            return typeSymbol.type.isErroneous() || !typeSymbol.exists();
        }
        return false;
    }

    public void _case(Tree.TopLevel topLevel) {
        this.DEBUG = DB.ONE(topLevel.sourcefile.toString());
        this.progressKeeper.progress(topLevel.sourcefile.toString());
        SpanDoctor spanDoctor = this.spanDoctor;
        Tree.TopLevel topLevel2 = this.currTopLevel;
        this.spanDoctor = null;
        this.currTopLevel = topLevel;
        String string = topLevel.sourcefile.toString();
        String string2 = topLevel.pid == null ? "" : this.fullName((Symbol)topLevel.packge);
        this.cleaner.fileStart(string, string2);
        this.allScopes.add(topLevel.packge.members());
        this.reportedVarDefs = null;
        this.visitList(topLevel.defs);
        this.currTopLevel = topLevel2;
        this.spanDoctor = spanDoctor;
    }

    public void _case(Tree.Import import_) {
    }

    public void _case(Tree.ClassDef classDef) {
        Tree.ClassDef classDef2 = this.currClassDef;
        String string = this.currClassName;
        String string2 = this.currFullClassName;
        this.currClassDef = classDef;
        this.currClassName = this.currClassDef.sym.name.toString();
        this.currFullClassName = classDef.sym.toJava();
        this.currClassName = CleanerPass1.getLastBit(this.currFullClassName);
        Map map = this.gatherVisibleInners((Type.ClassType)classDef.type);
        this.cleaner.classStart(this.currFullClassName, map);
        this.visitTree(classDef.extending);
        this.visitList(classDef.implementing);
        this.visitList(classDef.defs);
        this.currFullClassName = string2;
        this.currClassName = string;
        this.currClassDef = classDef2;
    }

    static String getLastBit(String string) {
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private Map gatherVisibleInners(Type.ClassType classType) {
        if (this.DEBUG) {
            System.err.println("++++ " + classType);
        }
        HashMap hashMap = new HashMap();
        this.gatherVisibleInnersOfSupersAndInterfaces(">SUPER>", classType, hashMap);
        this.gatherVisibleInnersOfOuters(classType, hashMap);
        return hashMap;
    }

    private void gatherVisibleInnersOfSupersAndInterfaces(String string, Type.ClassType classType, Map map) {
        Type.ClassType classType2 = classType;
        while (classType2 != null && classType2 instanceof Type.ClassType && classType2.tsym.fullName() != Names.java_lang_Object) {
            this.enterAllClassesInScope(string, classType2.tsym.members(), map);
            if (classType2 != classType) {
                this.gatherVisibleInnersOfSupersAndInterfaces(string + "E>", classType2, map);
            }
            classType2 = classType2.supertype();
        }
        List list = classType.interfaces();
        while (list != null && list.nonEmpty()) {
            Object object = list.head;
            if (object instanceof Type.ClassType) {
                this.gatherVisibleInnersOfSupersAndInterfaces(string + "I>", (Type.ClassType)object, map);
            }
            list = list.tail;
        }
    }

    private void gatherVisibleInnersOfOuters(Type.ClassType classType, Map map) {
        Symbol symbol = classType.tsym.owner;
        while (symbol != null && !(symbol instanceof Symbol.PackageSymbol)) {
            if (symbol instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
                if (classSymbol.type instanceof Type.ClassType) {
                    this.gatherVisibleInnersOfSupersAndInterfaces(">OUTER>", (Type.ClassType)classSymbol.type, map);
                } else {
                    this.enterAllClassesInScope(">outer>", classSymbol.members(), map);
                }
            }
            symbol = symbol.owner;
        }
    }

    private void enterAllClassesInScope(String string, Scope scope, Map map) {
        Scope.Entry entry = scope.elems;
        while (entry != null && entry.sym != null) {
            if (entry.sym instanceof Symbol.ClassSymbol) {
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)entry.sym;
                String string2 = classSymbol.name.toString();
                if (!map.containsKey(string2)) {
                    map.put(string2, classSymbol.fullName().toString());
                    if (this.DEBUG) {
                        System.err.println(string + "  ----- " + classSymbol + " [" + classSymbol.getClass().getName() + "]");
                    }
                } else if (this.DEBUG) {
                    System.err.println(string + "  -DUP- " + classSymbol + " [" + classSymbol.getClass().getName() + "]");
                }
            }
            entry = entry.sibling;
        }
    }

    public void _case(Tree.MethodDef methodDef) {
        if ((methodDef.flags & 0x10000) == 0) {
            boolean bl;
            boolean bl2 = this.currClassDef.sym == null || this.currClassDef.sym.name == Names.empty;
            boolean bl3 = methodDef.pos == this.currClassDef.pos && !bl2;
            boolean bl4 = bl = methodDef.name == Names.init;
            if (!(bl3 || methodDef.sym == null || bl2 && bl)) {
                this.visitTree(methodDef.restype);
                this.visitList(methodDef.params);
                this.visitList(methodDef.thrown);
                this.visitTree((Tree)methodDef.body);
            }
        }
    }

    public void _case(Tree.VarDef varDef) {
        if ((varDef.flags & 0x10000) == 0) {
            this.visitTree(varDef.vartype);
            this.visitTree(varDef.init);
        }
    }

    public void _case(Tree.Select select) {
        if (select.sym != null && select.sym instanceof Symbol.ClassSymbol) {
            this.classDependency((Tree)select);
        }
        this.visitTree(select.selected);
    }

    public void _case(Tree.Ident ident) {
        if (ident.sym != null && ident.sym instanceof Symbol.ClassSymbol) {
            this.classDependency((Tree)ident);
        }
    }

    public void _case(Tree.Skip skip) {
    }

    public void _case(Tree.Block block) {
        this.visitList(block.stats);
    }

    public void _case(Tree.DoLoop doLoop) {
        this.visitTree(doLoop.cond);
        this.visitTree(doLoop.body);
    }

    public void _case(Tree.WhileLoop whileLoop) {
        this.visitTree(whileLoop.cond);
        this.visitTree(whileLoop.body);
    }

    public void _case(Tree.ForLoop forLoop) {
        this.visitList(forLoop.init);
        this.visitTree(forLoop.cond);
        this.visitList(forLoop.step);
        this.visitTree(forLoop.body);
    }

    public void _case(Tree.Labelled labelled) {
        this.visitTree(labelled.body);
    }

    public void _case(Tree.Switch switch_) {
        this.visitTree(switch_.selector);
        this.visitList(switch_.cases);
    }

    public void _case(Tree.Case case_) {
        this.visitTree(case_.pat);
        this.visitList(case_.stats);
    }

    public void _case(Tree.Synchronized synchronized_) {
        this.visitTree(synchronized_.lock);
        this.visitTree(synchronized_.body);
    }

    public void _case(Tree.Try try_) {
        this.visitTree(try_.body);
        this.visitList(try_.catchers);
        this.visitTree(try_.finalizer);
    }

    public void _case(Tree.Catch catch_) {
        this.visitTree((Tree)catch_.param);
        this.visitTree(catch_.body);
    }

    public void _case(Tree.Conditional conditional) {
        this.visitTree(conditional.cond);
        this.visitTree(conditional.truepart);
        this.visitTree(conditional.falsepart);
    }

    public void _case(Tree.If if_) {
        this.visitTree(if_.cond);
        this.visitTree(if_.thenpart);
        this.visitTree(if_.elsepart);
    }

    public void _case(Tree.Exec exec) {
        this.visitTree(exec.expr);
    }

    public void _case(Tree.Break break_) {
    }

    public void _case(Tree.Continue continue_) {
    }

    public void _case(Tree.Return return_) {
        this.visitTree(return_.expr);
    }

    public void _case(Tree.Throw throw_) {
        this.visitTree(throw_.expr);
    }

    public void _case(Tree.Assert assert_) {
        this.visitTree(assert_.cond);
        this.visitTree(assert_.detail);
    }

    public void _case(Tree.Apply apply) {
        this.visitTree(apply.meth);
        this.visitList(apply.args);
    }

    public void _case(Tree.NewClass newClass) {
        this.visitTree(newClass.encl);
        if (newClass.def == null) {
            this.visitTree(newClass.clazz);
            this.visitList(newClass.args);
        } else {
            this.visitList(newClass.args);
            this.visitTree((Tree)newClass.def);
        }
    }

    public void _case(Tree.NewArray newArray) {
        this.visitTree(newArray.elemtype);
        this.visitList(newArray.dims);
        this.visitList(newArray.elems);
    }

    public void _case(Tree.Parens parens) {
        this.visitTree(parens.expr);
    }

    public void _case(Tree.Assign assign) {
        this.visitTree(assign.lhs);
        this.visitTree(assign.rhs);
    }

    public void _case(Tree.Assignop assignop) {
        this.visitTree(assignop.lhs);
        this.visitTree(assignop.rhs);
    }

    public void _case(Tree.Operation operation) {
        this.visitList(operation.args);
    }

    public void _case(Tree.TypeCast typeCast) {
        this.visitTree(typeCast.expr);
        this.visitTree(typeCast.clazz);
    }

    public void _case(Tree.TypeTest typeTest) {
        this.visitTree(typeTest.expr);
        this.visitTree(typeTest.clazz);
    }

    public void _case(Tree.Indexed indexed) {
        this.visitTree(indexed.indexed);
        this.visitTree(indexed.index);
    }

    public void _case(Tree.Literal literal) {
    }

    public void _case(Tree.TypeIdent typeIdent) {
    }

    public void _case(Tree.TypeArray typeArray) {
        this.visitTree(typeArray.elemtype);
    }

    public void _case(Tree.Erroneous erroneous) {
    }

    private static void dumpScope(Scope scope) {
        System.err.println("Scope dump (" + scope + ")");
        System.err.println("   nelems    = " + scope.nelems);
        System.err.println("   length    = " + scope.table.length);
        System.err.println("   owner     = " + scope.owner);
        System.err.println("   owner.fullName()  = " + scope.owner.fullName());
        System.err.println("   owner.flatName()  = " + scope.owner.flatName());
        System.err.println("   scopeName  = " + scope.owner.fullName());
        Set set = CleanerPass1.getClassSymbolsFromScope(scope);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)iterator.next();
            System.err.println("      - " + classSymbol);
        }
        if (scope.next != null) {
            System.err.println("*@*@*@*@*@* next:");
            CleanerPass1.dumpScope(scope.next);
        }
    }

    private class TreeProblem
    extends InternalProblem {
        public TreeProblem() {
        }

        public TreeProblem(String string) {
            super(string);
        }

        private void report() {
            CleanerPass1.this.cleaner.treeProblem(this.getMessage(), ((CleanerPass1)CleanerPass1.this).currTopLevel.sourcefile.toString());
        }
    }
}

