/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.cleanImports.model;

import com.tombrus.cleanImports.model.Import;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class ImportList {
    private Set imports = new HashSet();

    public ImportList() {
    }

    public ImportList(Collection collection) {
        this.addAll(collection);
    }

    public ImportList(Iterator iterator) {
        this.addAll(iterator);
    }

    public void addAll(Collection collection) {
        if (collection != null) {
            this.addAll(collection.iterator());
        }
    }

    public void addAll(Iterator iterator) {
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    public void add(Object object) {
        if (object instanceof Import) {
            this.imports.add((Import)object);
        } else {
            this.imports.add(new Import(object.toString()));
        }
    }

    public Iterator iterator() {
        return this.imports.iterator();
    }

    public Iterator sortedIterator() {
        ArrayList arrayList = new ArrayList(this.imports);
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                return object.toString().compareTo(object2.toString());
            }
        });
        return arrayList.iterator();
    }

    public boolean remove(Import import_) {
        return this.imports.remove(import_);
    }

    public int size() {
        return this.imports.size();
    }

    public String toString() {
        return this.imports.toString();
    }

    public ImportList collapse(int n) {
        Import import_;
        ArrayList arrayList = new ArrayList(this.imports);
        ArrayList<Import> arrayList2 = new ArrayList<Import>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            import_ = (Import)iterator.next();
            if (!import_.isUncollapseable()) continue;
            arrayList2.add(import_);
            iterator.remove();
        }
        while (arrayList.size() != 0) {
            import_ = new CollapsedImport(((Import)arrayList.get(0)).getPackageName());
            ((CollapsedImport)import_).absorbAll(arrayList);
            if (((CollapsedImport)import_).size() > n) {
                arrayList2.add(import_);
                continue;
            }
            arrayList2.addAll(((CollapsedImport)import_).getList());
        }
        return new ImportList(arrayList2);
    }

    public ImportList expand() {
        HashSet<Import> hashSet = new HashSet<Import>();
        Iterator iterator = this.imports.iterator();
        while (iterator.hasNext()) {
            Import import_ = (Import)iterator.next();
            if (import_ instanceof CollapsedImport) {
                hashSet.addAll(((CollapsedImport)import_).getList());
                continue;
            }
            hashSet.add(import_);
        }
        this.imports = hashSet;
        return this;
    }

    public ImportList extractMatching(String string, boolean bl) {
        return this.extractMatching(Pattern.compile(string), bl);
    }

    public ImportList extractMatching(Pattern pattern, boolean bl) {
        ImportList importList = new ImportList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Import import_ = (Import)iterator.next();
            if (!import_.findMatch(pattern) || bl && import_.isUncollapseable()) continue;
            iterator.remove();
            importList.add(import_);
        }
        return importList;
    }

    public ImportList copy() {
        return new ImportList(new ArrayList(this.imports));
    }

    public boolean contains(Import import_) {
        return this.imports.contains(import_);
    }

    public static class CollapsedImport
    extends Import {
        private List imports = new ArrayList();

        public CollapsedImport(Import import_) {
            this(import_.getPackageName());
            this.imports.add(import_);
        }

        public CollapsedImport(String string) {
            super(string, "*");
            if (this.getPackageName() == "") {
                throw new IllegalArgumentException("can not collapse default package");
            }
        }

        public boolean isUncollapseable() {
            return true;
        }

        public boolean canAbsorb(Import import_) {
            boolean bl;
            boolean bl2 = bl = !import_.isUncollapseable() && import_.getPackageName() == this.getPackageName();
            if (bl) {
                this.imports.add(import_);
            }
            return bl;
        }

        public void absorbAll(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Import) || !this.canAbsorb((Import)e)) continue;
                iterator.remove();
            }
        }

        public int size() {
            return this.imports.size();
        }

        public List getList() {
            return new ArrayList(this.imports);
        }
    }
}

