/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.cleanImports.engine;

import com.tombrus.util.InternalProblem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SortOfLexer {
    private static Pattern wordRE = Pattern.compile("[\\w.$*]+");
    private static Pattern whiteRE = Pattern.compile("\\p{Space}+");
    private static Pattern eolRE = Pattern.compile("(\r\n|\n|\r|$)", 8);
    private static Pattern slashCommentRE = Pattern.compile("//.*(\r\n|\n|\r|$)", 8);
    private static Pattern starCommentRE = Pattern.compile("/\\*.*?\\*/", 32);
    private static Map words = new HashMap();
    private List elements = new ArrayList();
    private String contents;
    private int current;
    private int length;

    SortOfLexer(String string) {
        this.contents = string;
        this.length = string.length();
        this.turnIntoElements();
    }

    private void turnIntoElements() {
        while (this.current < this.length) {
            if (this.acceptEOL() || this.acceptWhite() || this.acceptSlashComment() || this.acceptStarComment() || this.acceptWord() || this.acceptAny()) {
                if (this.getLastType() != 'c') continue;
                this.acceptTillTheEnd();
                continue;
            }
            throw new InternalProblem("4711");
        }
    }

    public String toTypeString() {
        return this.toTypeString(0, this.size());
    }

    public String toTypeString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n3 < n2) {
            stringBuffer.append(this.getType(n3));
            ++n3;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(0, this.size());
    }

    public String toString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n3 < n2) {
            if (!this.isRemoved(n3)) {
                stringBuffer.append(this.getValue(n3));
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    int size() {
        return this.elements.size();
    }

    char getType(int n) {
        return ((Element)this.elements.get((int)n)).type;
    }

    char getLastType() {
        return this.getType(this.size() - 1);
    }

    String getValue(int n) {
        return ((Element)this.elements.get(n)).getValue();
    }

    String getLastValue() {
        return this.getValue(this.size() - 1);
    }

    Element get(int n) {
        return (Element)this.elements.get(n);
    }

    Element getLast() {
        return this.get(this.size() - 1);
    }

    void remove(int n) {
        ((Element)this.elements.get((int)n)).type = (char)88;
    }

    boolean isRemoved(int n) {
        return ((Element)this.elements.get((int)n)).type == 'X';
    }

    private int matchAtStartGiveEnd(Pattern pattern) {
        Matcher matcher = pattern.matcher(this.contents.substring(this.current));
        return matcher.lookingAt() ? matcher.end() + this.current : -1;
    }

    private boolean acceptRE(Pattern pattern, char c) {
        int n = this.matchAtStartGiveEnd(pattern);
        if (n != -1) {
            this.elements.add(new Element(c, this.current, n));
            this.current = n;
        }
        return n != -1;
    }

    boolean acceptWhite() {
        return this.acceptRE(whiteRE, ' ');
    }

    boolean acceptEOL() {
        return this.acceptRE(eolRE, 'e');
    }

    boolean acceptSlashComment() {
        return this.acceptRE(slashCommentRE, '/');
    }

    boolean acceptStarComment() {
        return this.acceptRE(starCommentRE, '#');
    }

    boolean acceptWord() {
        int n = this.matchAtStartGiveEnd(wordRE);
        if (n != -1) {
            String string = this.contents.substring(this.current, n);
            char c = 'w';
            if (words.containsKey(string)) {
                c = ((String)words.get(string)).charAt(0);
            }
            this.elements.add(new Element(c, this.current, n));
            this.current = n;
        }
        return n != -1;
    }

    boolean acceptAny() {
        boolean bl;
        boolean bl2 = bl = this.current < this.length;
        if (bl) {
            this.elements.add(new Element(';', this.current, this.current + 1));
            ++this.current;
        }
        return bl;
    }

    boolean acceptTillTheEnd() {
        boolean bl;
        boolean bl2 = bl = this.current < this.length;
        if (bl) {
            this.elements.add(new Element('.', this.current, this.length));
            this.current = this.length;
        }
        return bl;
    }

    static {
        words.put("package", "p");
        words.put("import", "i");
        words.put("class", "c");
        words.put("interface", "c");
    }

    class Element {
        char type;
        int from;
        int to;
        String cachedValue;

        Element(char c, int n, int n2) {
            this.type = c;
            this.from = n;
            this.to = n2;
        }

        String getValue() {
            if (this.cachedValue == null) {
                this.cachedValue = SortOfLexer.this.contents.substring(this.from, this.to);
            }
            return this.cachedValue;
        }
    }
}

