/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.cleanImports.ant;

import com.tombrus.cleanImports.ant.CleanFormat;
import com.tombrus.cleanImports.engine.MultiImportReplacer;
import com.tombrus.cleanImports.model.ImportSpecification;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class CleanImports
extends MatchingTask {
    private Path src;
    private Path classpath;
    private String encoding;
    private CleanFormat cleanFormat;
    private String source;
    private String checkoutTarget;
    private String checkinTarget;
    private String debugVarName;
    private Target subTarget;

    public CleanImports() {
        this.classpath = new Path(this.project);
    }

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.project);
        }
        return this.src.createPath();
    }

    public void setSrcdir(Path path) {
        if (this.src == null) {
            this.src = path;
        } else {
            this.src.append(path);
        }
    }

    public Path getSrcdir() {
        return this.src;
    }

    public Path createClasspath() {
        return this.classpath;
    }

    public void setClasspath(Path path) {
        this.classpath.append(path);
    }

    public Path getClasspath() {
        return this.classpath;
    }

    public void setClasspathRef(Reference reference) {
        this.classpath = new Path(this.project);
        this.classpath.setRefid(reference);
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public String getCheckoutTarget() {
        return this.checkoutTarget;
    }

    public void setCheckoutTarget(String string) {
        this.checkoutTarget = string;
    }

    public String getCheckinTarget() {
        return this.checkinTarget;
    }

    public void setCheckinTarget(String string) {
        this.checkinTarget = string;
    }

    public String getDebugVarName() {
        return this.debugVarName;
    }

    public void setDebugVarName(String string) {
        this.debugVarName = string;
    }

    public void execute() throws BuildException {
        String[] stringArray;
        String[] stringArray2;
        if (this.subTarget != null) {
            int n = 0;
            while (n < 5) {
                this.subTarget.getProject().setProperty("zozo", "dat is " + n);
                this.subTarget.execute();
                ++n;
            }
        }
        String[] stringArray3 = stringArray2 = this.src == null ? null : this.src.list();
        if (stringArray2 == null || stringArray2.length == 0) {
            throw new BuildException("srcdir attribute must be set or <src> elements must be supplied", this.location);
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = 0;
        while (n < stringArray2.length) {
            File file = this.project.resolveFile(stringArray2[n]);
            if (!file.exists()) {
                throw new BuildException("srcdir \"" + file.getPath() + "\" does not exist!", this.location);
            }
            stringArray = Arrays.asList(this.getDirectoryScanner(file).getIncludedFiles()).iterator();
            while (stringArray.hasNext()) {
                String string = stringArray.next();
                if (!string.endsWith(".java")) continue;
                arrayList.add(new File(file, string));
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            this.log("Files to clean:", 3);
            int n2 = 0;
            while (n2 < arrayList.size()) {
                this.log(" - " + arrayList.get(n2), 3);
                ++n2;
            }
            this.classpath = this.classpath.concatSystemClasspath("last");
            stringArray = this.classpath.list();
            this.log("Classpath used:", 3);
            int n3 = 0;
            while (n3 < stringArray.length) {
                this.log(" - " + stringArray[n3], 3);
                ++n3;
            }
            try {
                File[] fileArray = arrayList.toArray(new File[0]);
                ArrayList arrayList2 = new ArrayList();
                ArrayList arrayList3 = new ArrayList();
                ArrayList arrayList4 = new ArrayList();
                MultiImportReplacer.replace(stringArray, this.makeExtraArgs(), this.makeSpecification(), fileArray, arrayList2, arrayList3, arrayList4);
                this.logResult(arrayList2, arrayList, "done", ".updated", false);
                this.logResult(arrayList3, arrayList, "not needed", ".unchanged", false);
                this.logResult(arrayList4, arrayList, "impossible", ".inerror", true);
            }
            catch (IOException iOException) {
                throw new BuildException("Could not clean imports: " + iOException.getMessage(), (Throwable)iOException, this.location);
            }
        }
    }

    private void logResult(List list, List list2, String string, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < list.size()) {
            stringBuffer.append(" - ").append(list.get(n));
            if (bl) {
                stringBuffer.append(" (").append(list.get(++n)).append(")");
            }
            stringBuffer.append("\n");
            ++n;
        }
        String string3 = stringBuffer.toString();
        if (list.size() != 0) {
            this.log("Import cleaning was " + string + " for " + list.size() / (bl ? 2 : 1) + " out of " + list2.size() + " files");
            this.log("Files that were updated:", 3);
            this.log(string3, 3);
            if (bl) {
                int n2 = 1;
                while (n2 < list.size()) {
                    if (list.get(n2) instanceof Throwable) {
                        Throwable throwable = (Throwable)list.get(n2);
                        this.log(throwable.toString(), 3);
                        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                        int n3 = 0;
                        while (n3 < stackTraceElementArray.length) {
                            this.log(" - " + stackTraceElementArray[n3].toString(), 3);
                            ++n3;
                        }
                    }
                    n2 += 2;
                }
            }
        }
        this.getProject().setProperty(this.getDebugVarName() + string2, String.valueOf(list.size()));
        this.getProject().setProperty(this.getDebugVarName() + string2 + ".files", string3);
    }

    private ImportSpecification makeSpecification() {
        ImportSpecification importSpecification = null;
        if (this.cleanFormat != null) {
            importSpecification = this.cleanFormat.getCleanFormat().getImportSpecification();
        }
        return importSpecification;
    }

    private HashMap makeExtraArgs() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.encoding != null) {
            hashMap.put("-encoding", this.encoding);
        }
        if (this.source != null) {
            boolean bl;
            boolean bl2 = bl = Project.getJavaVersion() != "1.0" && Project.getJavaVersion() != "1.1" && Project.getJavaVersion() != "1.2" && Project.getJavaVersion() != "1.3";
            if (bl) {
                hashMap.put("-source", this.source);
            }
        }
        return hashMap;
    }

    public CleanFormat createCleanFormat() {
        if (this.cleanFormat != null) {
            throw new BuildException("there may be only one <cleanFormat> member", this.location);
        }
        this.cleanFormat = new CleanFormat(this.project);
        return this.cleanFormat;
    }

    public Target createTarget() {
        this.subTarget = new Target();
        System.out.println("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX project=" + this.project);
        System.out.println("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX subTarget=" + System.identityHashCode(this.target) + "==" + this.subTarget.getClass().getName());
        this.subTarget.setProject(this.project);
        return this.subTarget;
    }
}

