/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.rpc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jboss.cache.TreeCache;
import org.jboss.cache.rpc.NoHandlerForRPCException;
import org.jboss.cache.rpc.RpcTreeCacheMBean;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.blocks.MethodCall;

public class RpcTreeCache
extends TreeCache
implements RpcTreeCacheMBean {
    public static Method dispatchRpcCallMethod = null;
    protected Map rpcHandlers = new HashMap();
    private boolean trace = log.isTraceEnabled();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$jgroups$blocks$MethodCall;
    static /* synthetic */ Class class$org$jboss$cache$rpc$RpcTreeCache;

    public RpcTreeCache(String cluster_name, String props, long state_fetch_timeout) throws Exception {
        super(cluster_name, props, state_fetch_timeout);
    }

    public RpcTreeCache() throws Exception {
    }

    public RpcTreeCache(JChannel channel) throws Exception {
        super(channel);
    }

    public List callRemoteMethods(String serviceName, Vector members, Method method, Object[] args, boolean synchronous, boolean exclude_self, long timeout) throws Exception {
        return this.callRemoteMethods(serviceName, members, new MethodCall(method, args), synchronous, exclude_self, timeout);
    }

    public List callRemoteMethods(String serviceName, Vector mbrs, MethodCall method_call, boolean synchronous, boolean exclude_self, long timeout) throws Exception {
        List responses;
        block5: {
            block3: {
                block4: {
                    Object resp;
                    responses = null;
                    if (this.cache_mode != 1) break block3;
                    if (!synchronous) break block4;
                    responses = new ArrayList<Object>();
                    if (!exclude_self && !((resp = this._dispatchRpcCall(serviceName, method_call)) instanceof NoHandlerForRPCException)) {
                        responses.add(this._dispatchRpcCall(serviceName, method_call));
                    }
                    break block5;
                }
                if (exclude_self) break block5;
                this._dispatchRpcCall(serviceName, method_call);
                break block5;
            }
            MethodCall wrapper = new MethodCall(dispatchRpcCallMethod, new Object[]{serviceName, method_call});
            responses = this.callRemoteMethods(mbrs, wrapper, synchronous, exclude_self, timeout);
            if (responses != null) {
                for (int i = 0; i < responses.size(); ++i) {
                    Object obj = responses.get(i);
                    if (!(obj instanceof NoHandlerForRPCException)) continue;
                    responses.remove(i);
                    --i;
                }
            }
        }
        return responses;
    }

    public List callRemoteMethods(String serviceName, Vector members, String method_name, Class[] types, Object[] args, boolean synchronous, boolean exclude_self, long timeout) throws Exception {
        Object handler = this.rpcHandlers.get(serviceName);
        if (handler == null) {
            String msg = "No rpc handler registered under: " + serviceName;
            log.trace((Object)msg);
            throw new NoHandlerForRPCException(msg);
        }
        Method method = handler.getClass().getDeclaredMethod(method_name, types);
        return this.callRemoteMethods(serviceName, members, method, args, synchronous, exclude_self, timeout);
    }

    public void registerRPCHandler(String serviceName, Object handler) {
        this.rpcHandlers.put(serviceName, handler);
    }

    public void unregisterRPCHandler(String serviceName, Object handler) {
        Object registered = this.rpcHandlers.remove(serviceName);
        if (handler != registered) {
            this.rpcHandlers.put(serviceName, handler);
        }
    }

    public Object _dispatchRpcCall(String serviceName, MethodCall call) {
        Object retval = null;
        Object handler = this.rpcHandlers.get(serviceName);
        if (handler == null) {
            String msg = "No rpc handler registered under: " + serviceName;
            log.trace((Object)msg);
            return new NoHandlerForRPCException(msg, (Address)this.getLocalAddress());
        }
        try {
            retval = call.invoke(handler);
        }
        catch (Throwable t) {
            if (this.trace) {
                log.trace((Object)"rpc call threw exception", t);
            }
            retval = t;
        }
        return retval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            dispatchRpcCallMethod = (class$org$jboss$cache$rpc$RpcTreeCache == null ? (class$org$jboss$cache$rpc$RpcTreeCache = RpcTreeCache.class$("org.jboss.cache.rpc.RpcTreeCache")) : class$org$jboss$cache$rpc$RpcTreeCache).getDeclaredMethod("_dispatchRpcCall", class$java$lang$String == null ? (class$java$lang$String = RpcTreeCache.class$("java.lang.String")) : class$java$lang$String, class$org$jgroups$blocks$MethodCall == null ? (class$org$jgroups$blocks$MethodCall = RpcTreeCache.class$("org.jgroups.blocks.MethodCall")) : class$org$jgroups$blocks$MethodCall);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex.toString());
        }
    }
}

