/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader.rmi;

import java.rmi.Naming;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TreeCache;
import org.jboss.cache.loader.rmi.RemoteTreeCacheImpl;

public class RmiCacheServer {
    TreeCache cache;
    RemoteTreeCacheImpl remoteObj;
    String host;
    int port;
    String configFile;
    final String SUFFIX = "CACHE_SERVER";

    public RmiCacheServer(String host, int port, String config) {
        this.host = host;
        this.port = port;
        this.configFile = config;
    }

    public void start() throws Exception {
        this.cache = new TreeCache();
        PropertyConfigurator config = new PropertyConfigurator();
        config.configure((Object)this.cache, this.configFile);
        this.cache.createService();
        this.cache.startService();
        this.remoteObj = new RemoteTreeCacheImpl(this.cache);
        Naming.rebind("//" + this.host + ":" + this.port + "/" + "CACHE_SERVER", this.remoteObj);
    }

    public void stop() {
        if (this.cache != null) {
            this.cache.stopService();
            this.cache.destroyService();
            this.cache = null;
        }
        if (this.remoteObj != null) {
            try {
                Naming.unbind("//" + this.host + ":" + this.port + "/" + "CACHE_SERVER");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        String host = "localhost";
        String configFile = "cache-service.xml";
        int port = 1098;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-host")) {
                host = args[++i];
                continue;
            }
            if (args[i].equals("-port")) {
                port = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("-config")) {
                configFile = args[++i];
                continue;
            }
            RmiCacheServer.help();
            return;
        }
        RmiCacheServer server = new RmiCacheServer(host, port, configFile);
        try {
            server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void help() {
        System.out.println("CacheServer [-host <host>] [-port <port>] [-config <cache config>][-help]");
    }
}

