/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.jboss.cache.CacheException;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jgroups.blocks.MethodCall;

public class OptimisticLockingInterceptor
extends OptimisticInterceptor {
    private long lockAcquisitionTimeout;

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.lockAcquisitionTimeout = cache.getLockAcquisitionTimeout();
    }

    public Object invoke(MethodCall m) throws Throwable {
        InvocationContext ctx = this.getInvocationContext();
        Object retval = null;
        Method meth = m.getMethod();
        if (meth.equals(TreeCache.lockMethodLocal)) {
            this.log.warn((Object)"OptimisticLockingInterceptor intercepted a call to TreeCache._lock().  This should NEVER be called if optimistic locking is used!!  Not allowing this call to proceed further down the chain.");
            return retval;
        }
        if (ctx.getTransaction() != null) {
            GlobalTransaction gtx = ctx.getGlobalTransaction();
            if (gtx == null) {
                throw new Exception("failed to get global transaction");
            }
            if (meth.equals(TreeCache.optimisticPrepareMethod)) {
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Calling lockNodes() with gtx " + ctx.getGlobalTransaction()));
                    }
                    this.lockNodes(gtx);
                }
                catch (Throwable e) {
                    this.log.debug((Object)"Caught exception attempting to lock nodes ", e);
                    try {
                        this.unlock(gtx);
                    }
                    catch (Throwable t) {
                        this.log.fatal((Object)"Failed to unlock on prepare ", t);
                    }
                    throw e;
                }
                retval = super.invoke(m);
            } else {
                if (meth.equals(TreeCache.commitMethod) || meth.equals(TreeCache.rollbackMethod)) {
                    try {
                        retval = super.invoke(m);
                        this.unlock(gtx);
                    }
                    catch (Throwable t) {
                        this.log.debug((Object)("exception encountered on " + meth + " running unlock "), t);
                        try {
                            this.unlock(gtx);
                        }
                        catch (Throwable ct) {
                            this.log.fatal((Object)("Failed to unlock on " + meth), t);
                        }
                        throw t;
                    }
                }
                retval = super.invoke(m);
            }
        } else {
            throw new CacheException("not in a transaction");
        }
        return retval;
    }

    private Object lockNodes(GlobalTransaction gtx) throws Exception {
        TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
        this.log.debug((Object)"locking nodes");
        Collection nodes = workspace.getNodes().values();
        Iterator it = nodes.iterator();
        while (it.hasNext()) {
            WorkspaceNode workspaceNode = (WorkspaceNode)it.next();
            boolean acquired = workspaceNode.getNode().acquire(gtx, this.lockAcquisitionTimeout, 2);
            if (acquired) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("acquired lock on node " + workspaceNode.getNode().getName()));
                }
                this.cache.getTransactionTable().addLock(gtx, workspaceNode.getNode().getLock());
                continue;
            }
            throw new CacheException("unable to acquire lock on node " + workspaceNode.getNode().getName());
        }
        return null;
    }

    private Object unlock(GlobalTransaction gtx) {
        TransactionEntry entry = this.txTable.get(gtx);
        LinkedList list = new LinkedList(entry.getLocks());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            IdentityLock lock = (IdentityLock)it.next();
            this.log.debug((Object)("releasing lock " + lock));
            lock.release(gtx);
        }
        return null;
    }
}

