/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.HashSet;
import java.util.Set;
import javax.transaction.Transaction;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.Interceptor;
import org.jgroups.blocks.MethodCall;

public class CallInterceptor
extends Interceptor {
    private static Set transactionLifecycleMethods = new HashSet();

    public void setCache(TreeCache cache) {
        super.setCache(cache);
    }

    public Object invoke(MethodCall m) throws Throwable {
        InvocationContext ctx;
        Transaction tx;
        Object retval = null;
        if (!transactionLifecycleMethods.contains(m.getMethod())) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Invoking method " + m + " on cache."));
            }
            try {
                retval = m.invoke((Object)this.cache);
            }
            catch (Throwable t) {
                retval = t;
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Suppressing invocation of method " + m + " on cache."));
        }
        if ((tx = (ctx = this.getInvocationContext()).getTransaction()) != null && this.isValid(tx)) {
            if (retval != null && retval instanceof Throwable) {
                tx.setRollbackOnly();
            } else if (!this.cache.isNodeLockingOptimistic() && TreeCache.isCrudMethod(m.getMethod())) {
                GlobalTransaction gtx = ctx.getGlobalTransaction();
                if (gtx == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("didn't find GlobalTransaction for " + tx + "; won't add modification to transaction list"));
                    }
                } else {
                    this.cache.getTransactionTable().addModification(gtx, m);
                }
            }
        }
        if (retval != null && retval instanceof Throwable) {
            throw (Throwable)retval;
        }
        return retval;
    }

    static {
        transactionLifecycleMethods.add(TreeCache.commitMethod);
        transactionLifecycleMethods.add(TreeCache.rollbackMethod);
        transactionLifecycleMethods.add(TreeCache.prepareMethod);
        transactionLifecycleMethods.add(TreeCache.optimisticPrepareMethod);
    }
}

