/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.transaction.TransactionManager;
import org.jboss.cache.Fqn;
import org.jboss.cache.GlobalTransaction;
import org.jboss.cache.Modification;
import org.jboss.cache.TransactionEntry;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.TreeCache;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.loader.CacheLoader;
import org.jgroups.blocks.MethodCall;

public class CacheStoreInterceptor
extends Interceptor {
    protected CacheLoader loader = null;
    protected CacheLoaderConfig loaderConfig = null;
    protected TransactionManager tx_mgr = null;
    protected TransactionTable tx_table = null;
    protected ConcurrentHashMap transactions = new ConcurrentHashMap(16);
    protected static final Object NULL = new Object();

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.loader = cache.getCacheLoader();
        this.loaderConfig = cache.getCacheLoaderManager().getCacheLoaderConfig();
        this.tx_mgr = cache.getTransactionManager();
        this.tx_table = cache.getTransactionTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodCall m) throws Throwable {
        Object key;
        Fqn fqn;
        if (!this.getInvocationContext().isOriginLocal() && this.loaderConfig.isShared()) {
            this.log.trace((Object)"Passing up method call and bypassing this interceptor since the cache loader is shared and this call originated remotely.");
            return super.invoke(m);
        }
        Method meth = m.getMethod();
        Object[] args = m.getArgs();
        Object retval = null;
        Object tmp_retval = null;
        boolean use_tmp_retval = false;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("CacheStoreInterceptor called with meth " + m));
        }
        if (this.tx_mgr != null && this.tx_mgr.getTransaction() != null) {
            this.log.trace((Object)"transactional so don't put stuff in the cloader yet.");
            GlobalTransaction gtx = this.getInvocationContext().getGlobalTransaction();
            if (TreeCache.commitMethod.equals(meth)) {
                if (this.hasModifications(m.getArgs())) {
                    this.getLoader().commit(gtx);
                } else {
                    this.log.trace((Object)"Commit called with no modifications; ignoring.");
                }
            } else if (TreeCache.rollbackMethod.equals(meth)) {
                if (this.hasModifications(m.getArgs())) {
                    this.getLoader().rollback(gtx);
                } else {
                    this.log.trace((Object)"Rollback called with no modifications; ignoring.");
                }
            } else if (TreeCache.optimisticPrepareMethod.equals(meth) || TreeCache.prepareMethod.equals(meth)) {
                this.prepareCacheLoader(gtx, this.isOnePhaseCommitPrepareMehod(m));
            }
            return super.invoke(m);
        }
        CacheStoreInterceptor cacheStoreInterceptor = this;
        synchronized (cacheStoreInterceptor) {
            if (meth.equals(TreeCache.removeNodeMethodLocal)) {
                fqn = (Fqn)args[1];
                this.loader.remove(fqn);
            } else if (meth.equals(TreeCache.removeKeyMethodLocal)) {
                fqn = (Fqn)args[1];
                key = args[2];
                tmp_retval = this.loader.remove(fqn, key);
                use_tmp_retval = true;
            } else if (meth.equals(TreeCache.removeDataMethodLocal)) {
                fqn = (Fqn)args[1];
                this.loader.removeData(fqn);
            }
        }
        retval = super.invoke(m);
        cacheStoreInterceptor = this;
        synchronized (cacheStoreInterceptor) {
            if (meth.equals(TreeCache.putDataMethodLocal) || meth.equals(TreeCache.putDataEraseMethodLocal)) {
                fqn = (Fqn)args[1];
                Map attributes = (Map)args[2];
                this.loader.put(fqn, attributes);
            } else if (meth.equals(TreeCache.putKeyValMethodLocal)) {
                fqn = (Fqn)args[1];
                key = args[2];
                Object value = args[3];
                this.loader.put(fqn, key, value);
            }
        }
        if (use_tmp_retval) {
            return tmp_retval;
        }
        return retval;
    }

    protected boolean hasModifications(Object[] args) {
        int hint = 1;
        if (args[hint] instanceof Boolean) {
            return (Boolean)args[hint];
        }
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Boolean)) continue;
            return (Boolean)args[i];
        }
        return false;
    }

    protected CacheLoader getLoader() {
        return this.loader != null ? this.loader : (this.loader = this.cache.getCacheLoader());
    }

    private void prepareCacheLoader(GlobalTransaction gtx, boolean onePhase) throws Exception {
        TransactionEntry entry = this.tx_table.get(gtx);
        if (entry == null) {
            throw new Exception("entry for transaction " + gtx + " not found in transaction table");
        }
        List modifications = entry.getModifications();
        if (modifications.size() == 0) {
            return;
        }
        ArrayList<Modification> cache_loader_modifications = new ArrayList<Modification>();
        Iterator it = modifications.iterator();
        while (it.hasNext()) {
            MethodCall methodCall = (MethodCall)it.next();
            Modification mod = this.convertMethodCallToModification(methodCall);
            cache_loader_modifications.add(mod);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Converted method calls to cache loader modifications.  List size: " + cache_loader_modifications.size()));
        }
        if (cache_loader_modifications.size() > 0) {
            this.loader.prepare(gtx, cache_loader_modifications, onePhase);
        }
    }

    protected Modification convertMethodCallToModification(MethodCall methodCall) throws Exception {
        Method method = methodCall.getMethod();
        if (method == null) {
            throw new Exception("method call has no method: " + methodCall);
        }
        Object[] args = methodCall.getArgs();
        if (TreeCache.putDataMethodLocal.equals(method)) {
            return new Modification(2, (Fqn)args[1], (Map)args[2]);
        }
        if (TreeCache.putDataEraseMethodLocal.equals(method)) {
            return new Modification(3, (Fqn)args[1], (Map)args[2]);
        }
        if (TreeCache.putKeyValMethodLocal.equals(method)) {
            return new Modification(1, (Fqn)args[1], args[2], args[3]);
        }
        if (TreeCache.removeNodeMethodLocal.equals(method)) {
            return new Modification(4, (Fqn)args[1]);
        }
        if (TreeCache.removeKeyMethodLocal.equals(method)) {
            return new Modification(5, (Fqn)args[1], args[2]);
        }
        if (TreeCache.removeDataMethodLocal.equals(method)) {
            return new Modification(6, (Fqn)args[1]);
        }
        throw new Exception("method call " + method.getName() + " cannot be converted to a modification");
    }
}

