/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.Fqn;

public class NodeEntry {
    private long modifiedTimeStamp_;
    private long creationTimeStamp_ = System.currentTimeMillis();
    private int numberOfNodeVisits_;
    private Fqn fqn_;

    private NodeEntry() {
    }

    public NodeEntry(Fqn fqn) {
        this();
        this.setFqn(fqn);
    }

    public NodeEntry(String fqn) {
        this();
        this.setFqn(Fqn.fromString(fqn));
    }

    public long getModifiedTimeStamp() {
        return this.modifiedTimeStamp_;
    }

    public void setModifiedTimeStamp(long modifiedTimeStamp) {
        this.modifiedTimeStamp_ = modifiedTimeStamp;
    }

    public long getCreationTimeStamp() {
        return this.creationTimeStamp_;
    }

    public void setCreationTimeStamp(long creationTimeStamp) {
        this.creationTimeStamp_ = creationTimeStamp;
    }

    public int getNumberOfNodeVisits() {
        return this.numberOfNodeVisits_;
    }

    public void setNumberOfNodeVisits(int numberOfNodeVisits) {
        this.numberOfNodeVisits_ = numberOfNodeVisits;
    }

    public Fqn getFqn() {
        return this.fqn_;
    }

    void setFqn(Fqn fqn) {
        this.fqn_ = fqn;
    }

    public int hashCode() {
        return this.fqn_.toString().hashCode();
    }

    public boolean equals(Object o) {
        NodeEntry ne = (NodeEntry)o;
        return this.fqn_.toString().equals(ne.getFqn().toString());
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("Fqn: ");
        if (this.fqn_ != null) {
            output.append(this.fqn_);
        } else {
            output.append(" null");
        }
        output.append(" CreateTime: ").append(this.getCreationTimeStamp());
        output.append(" NodeVisits: ").append(this.getNumberOfNodeVisits());
        output.append(" ModifiedTime: ").append(this.getModifiedTimeStamp());
        return output.toString();
    }
}

