/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.eviction.BaseSortedEvictionAlgorithm;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.LFUConfiguration;
import org.jboss.cache.eviction.LFUQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.jboss.cache.eviction.Region;

public class LFUAlgorithm
extends BaseSortedEvictionAlgorithm
implements EvictionAlgorithm {
    private static final Log log = LogFactory.getLog((Class)(class$org$jboss$cache$eviction$LFUAlgorithm == null ? (class$org$jboss$cache$eviction$LFUAlgorithm = LFUAlgorithm.class$("org.jboss.cache.eviction.LFUAlgorithm")) : class$org$jboss$cache$eviction$LFUAlgorithm));
    static /* synthetic */ Class class$org$jboss$cache$eviction$LFUAlgorithm;

    protected boolean shouldEvictNode(NodeEntry ne) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Deciding whether node in queue " + ne.getFqn() + " requires eviction."));
        }
        LFUConfiguration config = (LFUConfiguration)this.region.getEvictionConfiguration();
        int size = this.getEvictionQueue().size();
        if (config.getMaxNodes() != 0 && size > config.getMaxNodes()) {
            return true;
        }
        return size > config.getMinNodes();
    }

    protected EvictionQueue setupEvictionQueue(Region region) throws EvictionException {
        return new LFUQueue();
    }

    protected void prune() throws EvictionException {
        super.prune();
        ((LFUQueue)this.evictionQueue).prune();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

