/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.eviction;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionException;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.EvictionQueue;
import org.jboss.cache.eviction.NodeEntry;
import org.jboss.cache.eviction.Region;
import org.jboss.cache.lock.TimeoutException;

public abstract class BaseEvictionAlgorithm
implements EvictionAlgorithm {
    private static final Log log = LogFactory.getLog((Class)(class$org$jboss$cache$eviction$BaseEvictionAlgorithm == null ? (class$org$jboss$cache$eviction$BaseEvictionAlgorithm = BaseEvictionAlgorithm.class$("org.jboss.cache.eviction.BaseEvictionAlgorithm")) : class$org$jboss$cache$eviction$BaseEvictionAlgorithm));
    protected Region region;
    protected BoundedBuffer recycleQueue = new BoundedBuffer();
    protected EvictionQueue evictionQueue;
    static /* synthetic */ Class class$org$jboss$cache$eviction$BaseEvictionAlgorithm;

    protected abstract EvictionQueue setupEvictionQueue(Region var1) throws EvictionException;

    protected abstract boolean shouldEvictNode(NodeEntry var1);

    protected BaseEvictionAlgorithm() {
    }

    protected void initialize(Region region) throws EvictionException {
        this.region = region;
        this.evictionQueue = this.setupEvictionQueue(region);
    }

    public void process(Region region) throws EvictionException {
        if (this.region == null) {
            this.initialize(region);
        }
        this.processQueues(region);
        this.emptyRecycleQueue();
        this.prune();
    }

    public void resetEvictionQueue(Region region) {
    }

    public EvictionQueue getEvictionQueue() {
        return this.evictionQueue;
    }

    protected void processQueues(Region region) throws EvictionException {
        EvictedEventNode node;
        int count = 0;
        block5: while ((node = region.takeLastEventNode()) != null) {
            int eventType = node.getEvent();
            Fqn fqn = node.getFqn();
            ++count;
            switch (eventType) {
                case 0: {
                    this.processAddedNodes(fqn);
                    continue block5;
                }
                case 1: {
                    this.processRemovedNodes(fqn);
                    continue block5;
                }
                case 2: {
                    this.processVisitedNodes(fqn);
                    continue block5;
                }
            }
            throw new RuntimeException("Illegal Eviction Event type " + eventType);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("processed " + count + " node events"));
        }
    }

    protected void evict(NodeEntry ne) {
        if (ne != null) {
            this.evictionQueue.removeNodeEntry(ne);
            if (!this.evictCacheNode(ne.getFqn())) {
                try {
                    this.recycleQueue.put((Object)ne);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected boolean evictCacheNode(Fqn fqn) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Attempting to evict cache node with fqn of " + fqn));
        }
        EvictionPolicy policy = this.region.getEvictionPolicy();
        try {
            policy.evict(fqn);
        }
        catch (Exception e) {
            if (e instanceof TimeoutException) {
                log.warn((Object)("eviction of " + fqn + " timed out. Will retry later."));
                return false;
            }
            e.printStackTrace();
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Eviction of cache node with fqn of " + fqn + " successful"));
        }
        return true;
    }

    protected void processAddedNodes(Fqn fqn) throws EvictionException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Adding node " + fqn + " to eviction queue"));
        }
        long stamp = System.currentTimeMillis();
        NodeEntry ne = new NodeEntry(fqn);
        ne.setModifiedTimeStamp(stamp);
        ne.setNumberOfNodeVisits(1);
        if (this.evictionQueue.containsNodeEntry(ne)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Queue already contains " + ne.getFqn() + " processing it as visited"));
            }
            this.processVisitedNodes(ne.getFqn());
            return;
        }
        this.evictionQueue.addNodeEntry(ne);
        if (log.isTraceEnabled()) {
            log.trace((Object)(ne.getFqn() + " added successfully to eviction queue"));
        }
    }

    protected void processRemovedNodes(Fqn fqn) throws EvictionException {
        NodeEntry ne;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Removing node " + fqn + " from eviction queue and attempting eviction"));
        }
        if ((ne = this.evictionQueue.getNodeEntry(fqn)) != null) {
            this.evictionQueue.removeNodeEntry(ne);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)(fqn + " removed from eviction queue"));
        }
    }

    protected void processVisitedNodes(Fqn fqn) throws EvictionException {
        NodeEntry ne = this.evictionQueue.getNodeEntry(fqn);
        if (ne == null) {
            this.processAddedNodes(fqn);
            return;
        }
        ne.setNumberOfNodeVisits(ne.getNumberOfNodeVisits() + 1);
        ne.setModifiedTimeStamp(System.currentTimeMillis());
    }

    protected void emptyRecycleQueue() throws EvictionException {
        block6: {
            Fqn fqn;
            do {
                try {
                    fqn = (Fqn)this.recycleQueue.poll(0L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    break block6;
                }
                if (fqn == null) {
                    if (!log.isTraceEnabled()) break block6;
                    log.trace((Object)"Recycle queue is empty");
                    break block6;
                }
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("emptying recycle bin. Evict node " + fqn));
            } while (this.evictCacheNode(fqn));
            try {
                this.recycleQueue.put((Object)fqn);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void prune() throws EvictionException {
        NodeEntry entry;
        while ((entry = this.evictionQueue.getFirstNodeEntry()) != null && this.shouldEvictNode(entry)) {
            this.evict(entry);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

