/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class CacheLoaderConfig {
    private boolean passivation;
    private String preload;
    private List cacheLoaderConfigs = new ArrayList();
    private boolean shared;

    public String getPreload() {
        return this.preload;
    }

    public void setPreload(String preload) {
        this.preload = preload;
    }

    public void setPassivation(boolean passivation) {
        this.passivation = passivation;
    }

    public boolean isPassivation() {
        return this.passivation;
    }

    public void addIndividualCacheLoaderConfig(IndividualCacheLoaderConfig clc) {
        this.cacheLoaderConfigs.add(clc);
    }

    public List getIndividualCacheLoaderConfigs() {
        return this.cacheLoaderConfigs;
    }

    public IndividualCacheLoaderConfig getFirstCacheLoaderConfig() {
        if (this.cacheLoaderConfigs.size() == 0) {
            return null;
        }
        return (IndividualCacheLoaderConfig)this.cacheLoaderConfigs.get(0);
    }

    public boolean useChainingCacheLoader() {
        return !this.isPassivation() && this.cacheLoaderConfigs.size() > 1;
    }

    public String toString() {
        return "CacheLoaderConfig{" + "shared=" + this.shared + ", passivation=" + this.passivation + ", preload='" + this.preload + '\'' + ", cacheLoaderConfigs.size()=" + this.cacheLoaderConfigs.size() + '}';
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public boolean isShared() {
        return this.shared;
    }

    public class IndividualCacheLoaderConfig {
        private String className;
        private boolean async;
        private boolean ignoreModifications;
        private boolean fetchPersistentState;
        private Properties properties;

        public boolean isFetchPersistentState() {
            return this.fetchPersistentState;
        }

        public void setFetchPersistentState(boolean fetchPersistentState) {
            this.fetchPersistentState = fetchPersistentState;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public void setAsync(boolean async) {
            this.async = async;
        }

        public boolean isAsync() {
            return this.async;
        }

        public void setIgnoreModifications(boolean ignoreModifications) {
            this.ignoreModifications = ignoreModifications;
        }

        public boolean isIgnoreModifications() {
            return this.ignoreModifications;
        }

        public void setProperties(String properties) throws IOException {
            if (properties == null) {
                return;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(properties.trim().getBytes());
            this.properties = new Properties();
            this.properties.load(is);
            is.close();
        }

        public void setProperties(Properties properties) {
            this.properties = properties;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public String toString() {
            return "IndividualCacheLoaderConfig{" + "className='" + this.className + '\'' + ", async=" + this.async + ", ignoreModifications=" + this.ignoreModifications + ", fetchPersistentState=" + this.fetchPersistentState + ", properties=" + this.properties + '}';
        }
    }
}

