/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.transaction.Transaction;
import org.jboss.cache.config.Option;
import org.jboss.cache.lock.IdentityLock;
import org.jgroups.blocks.MethodCall;

public class TransactionEntry {
    protected Transaction ltx = null;
    protected Option option;
    protected List modification_list = new LinkedList();
    protected List undo_list = new LinkedList();
    protected List locks = new LinkedList();

    public void addModification(MethodCall m) {
        if (m == null) {
            return;
        }
        this.modification_list.add(m);
    }

    public List getModifications() {
        return this.modification_list;
    }

    public void addUndoOperation(MethodCall m) {
        this.undo_list.add(m);
    }

    public List getUndoOperations() {
        return this.undo_list;
    }

    public void setTransaction(Transaction tx) {
        this.ltx = tx;
    }

    public Transaction getTransaction() {
        return this.ltx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLock(IdentityLock l) {
        if (l != null) {
            List list = this.locks;
            synchronized (list) {
                if (!this.locks.contains(l)) {
                    this.locks.add(l);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocks(Collection newLocks) {
        if (newLocks != null) {
            List list = this.locks;
            synchronized (list) {
                Iterator it = newLocks.iterator();
                while (it.hasNext()) {
                    IdentityLock tmp = (IdentityLock)it.next();
                    if (this.locks.contains(tmp)) continue;
                    this.locks.add(tmp);
                }
            }
        }
    }

    public List getLocks() {
        return this.locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllLocks(Object owner) {
        List list = this.locks;
        synchronized (list) {
            Iterator it = this.locks.iterator();
            while (it.hasNext()) {
                IdentityLock lock = (IdentityLock)it.next();
                lock.release(owner);
            }
            this.locks.clear();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.modification_list != null) {
            sb.append("\nmodification_list: ").append(this.modification_list);
        }
        if (this.undo_list != null) {
            sb.append("\nundo_list: ").append(this.undo_list);
        }
        if (this.locks != null) {
            sb.append("\nlocks: ").append(this.locks);
        }
        return sb.toString();
    }

    public void setOption(Option o) {
        this.option = o;
    }

    public Option getOption() {
        return this.option;
    }
}

