/*
 * Decompiled with CFR 0.152.
 */
package net.mark_malakanov.sdg2;

import edu.usfca.syndiag.GraphicsEngine;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.io.FileWriter;
import java.io.IOException;

public class SvgEngine
implements GraphicsEngine {
    FileWriter wrtr;
    String title = "antlr svg";
    String color = "black";
    String bgColor = "none";
    String fillColor;
    String font_name = "arial";
    String font_size = "10";
    String stroke;
    String stroke_width = "1";
    String stroke_linecap = null;
    String stroke_join = null;
    String stroke_dasharray = null;
    String stroke_dashoffset = null;

    public void init(String title) {
        this.title = title;
    }

    public void setWriter(String FileName) {
        try {
            this.wrtr = new FileWriter(FileName);
        }
        catch (IOException e) {
            new RuntimeException(e);
        }
    }

    private void println(String s) {
        try {
            this.wrtr.write(s);
            this.wrtr.write("\n");
        }
        catch (IOException e) {
            new RuntimeException(e);
        }
    }

    public void setColor(Color c) {
        new Integer(c.getRGB());
        this.color = "#" + Integer.toHexString(6);
    }

    public void setColor(String c) {
        this.color = c;
    }

    public void setBgColor(Color c) {
        new Integer(c.getRGB());
        this.bgColor = "#" + Integer.toHexString(6);
    }

    public void setBgColor(String c) {
        this.bgColor = c;
    }

    public void beginDraw(Rectangle rect) {
        this.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.println("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1 Tiny//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11-tiny.dtd\">");
        this.println("<!--======================================================================-->");
        this.println("<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.2\" width=\"100%\" height=\"100%\" viewBox=\"0 0 " + String.valueOf(rect.width) + " " + String.valueOf(rect.width) + "\" >");
        this.println("<title id=\"antlr to swg\">" + this.title + "</title>");
        this.println("<g id=\"svg-body-content\">");
    }

    public void endDraw() {
        try {
            this.println("</g>");
            this.println("</svg>");
            this.wrtr.close();
        }
        catch (IOException e) {
            new RuntimeException(e);
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.println("<line x1=\"" + String.valueOf(x1) + "\" y1=\"" + String.valueOf(y1) + "\" x2=\"" + String.valueOf(x2) + "\" y2=\"" + String.valueOf(y2) + "\" stroke=\"" + this.color + "\"" + " stroke-width=\"" + this.stroke_width + "\" />");
    }

    public void drawString(String str, int x, int y) {
        this.println("<text x=\"" + String.valueOf(x) + "\" y=\"" + String.valueOf(y) + "\" font-size=\"" + this.font_size + "\" stroke=\"none\"" + "  fill=\"" + this.color + "\"" + " name=\"" + this.font_name + "\">" + str + "</text>");
    }

    public void setFont(Font f) {
        this.font_name = f.getFontName();
        this.font_size = String.valueOf(f.getSize());
    }

    public void drawString(String str, int x, int y, Font f) {
        this.setFont(f);
        this.drawString(str, x, y);
    }

    public void drawOval(int x, int y, int w, int h) {
        this.println("<rect x=\"" + String.valueOf(x) + "\" y=\"" + String.valueOf(y) + "\" width=\"" + String.valueOf(w) + "\" height=\"" + String.valueOf(h) + "\" rx=\"14\" ry=\"10\"" + " fill=\"" + this.bgColor + "\"" + " stroke=\"" + this.color + "\"" + " stroke-width=\"" + this.stroke_width + "\" />");
    }

    public String strokeToString(Stroke s) {
        String ss = "";
        BasicStroke bs = (BasicStroke)s;
        String stroke_width = String.valueOf(bs.getLineWidth());
        String stroke_linecap = "inherit";
        switch (bs.getEndCap()) {
            case 0: {
                stroke_linecap = "butt";
                break;
            }
            case 1: {
                stroke_linecap = "round";
                break;
            }
            case 2: {
                stroke_linecap = "square";
                break;
            }
        }
        String stroke_join = "inherit";
        switch (bs.getLineJoin()) {
            case 2: {
                stroke_join = "bevel";
                break;
            }
            case 0: {
                stroke_join = "miter";
                break;
            }
            case 1: {
                stroke_join = "round";
                break;
            }
        }
        float[] f = bs.getDashArray();
        String stroke_dasharray = "";
        for (int i = 0; i < f.length; ++i) {
            stroke_dasharray = String.valueOf(stroke_dasharray) + String.valueOf(f[i]) + (i < f.length - 1 ? "," : "");
        }
        String stroke_dashoffset = String.valueOf(bs.getDashPhase());
        ss = String.valueOf(ss) + " stroke-width=\"" + stroke_width + "\"";
        if (stroke_dasharray != null) {
            ss = String.valueOf(ss) + " stroke-dasharray=\"" + stroke_dasharray + "\" stroke-dashoffset=\"" + stroke_dashoffset + "\"";
        }
        if (stroke_join != null) {
            ss = String.valueOf(ss) + " stroke-join=\"" + stroke_join + "\"";
        }
        if (stroke_linecap != null) {
            ss = String.valueOf(ss) + " stroke-linecap=\"" + stroke_linecap + "\"";
        }
        return ss;
    }

    public void drawRect(int x, int y, int w, int h, Stroke s) {
        String strokeAttribs = "";
        if (s != null) {
            strokeAttribs = this.strokeToString(s);
        }
        String rect = "<rect x=\"" + String.valueOf(x) + "\" y=\"" + String.valueOf(y) + "\" width=\"" + String.valueOf(w) + "\" height=\"" + String.valueOf(h) + "\" fill=\"" + this.bgColor + "\"" + " stroke=\"" + this.color + "\" " + strokeAttribs + " />";
        this.println(rect);
    }

    public void drawRect(int x, int y, int w, int h) {
        this.drawRect(x, y, w, h, null);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        String points = "";
        for (int i = 0; i < nPoints; ++i) {
            points = String.valueOf(points) + String.valueOf(xPoints[i]) + "," + String.valueOf(yPoints[i]) + " ";
        }
        this.println("<polygon  fill=\"" + this.color + "\"" + " stroke=\"" + this.color + "\"" + " stroke-width=\"" + this.stroke_width + "\"" + " points=\"" + points + "\" />");
    }
}

