/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hashi;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Direction;
import pencilbox.common.gui.PanelBase;
import pencilbox.hashi.Board;
import pencilbox.hashi.Pier;
import pencilbox.util.Colors;

public class Panel
extends PanelBase {
    private Board board;
    private boolean separateLinkColorMode = false;
    private boolean indicateErrorMode = false;
    private Color lineColor = new Color(153);
    private Color successColor = Color.GREEN;

    public Panel() {
        this.setGridColor(Color.GRAY);
        this.setGridStyle(0);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public boolean isSeparateLinkColorMode() {
        return this.separateLinkColorMode;
    }

    public void setSeparateLinkColorMode(boolean separateLinkColorMode) {
        this.separateLinkColorMode = separateLinkColorMode;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.drawGrid(g);
        this.drawBridgesAndPiers(g);
        this.drawBoardBorder(g);
    }

    private void drawBridgesAndPiers(Graphics2D g) {
        Address p;
        g.setFont(this.getNumberFont());
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            if (this.board.isPier(p)) {
                Pier pier = this.board.getPier(p);
                if (this.isSeparateLinkColorMode()) {
                    g.setColor(Colors.getColor(pier.getChain()));
                } else {
                    g.setColor(this.getLineColor());
                }
                int[] nArray = Direction.DN_RT;
                int n3 = Direction.DN_RT.length;
                int n4 = 0;
                while (n4 < n3) {
                    int d = nArray[n4];
                    int l = pier.getLine(d);
                    if (l > 0) {
                        Address pp = Address.nextCell(p, d);
                        while (!this.board.isPier(pp)) {
                            this.placeBridge(g, pp, d & 1, l);
                            pp = Address.nextCell(pp, d);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        addressArray = this.board.cellAddrs();
        n = addressArray.length;
        n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            if (this.board.isPier(p)) {
                if (this.isIndicateErrorMode()) {
                    int check = this.board.checkNumber(p);
                    if (check < 0) {
                        g.setColor(this.getErrorColor());
                        this.placeFilledCircle(g, p, this.getCellSize());
                    } else if (check == 0) {
                        g.setColor(this.successColor);
                        this.placeFilledCircle(g, p, this.getCellSize());
                    }
                }
                g.setColor(this.getNumberColor());
                this.placeCircle(g, p, this.getCellSize());
                int n5 = this.board.getNumber(p);
                if (n5 >= 1 && n5 <= 8) {
                    this.placeNumber(g, p, n5);
                }
            }
            ++n2;
        }
    }

    public void placeBridge(Graphics2D g, Address p, int dir, int n) {
        if (n == 1) {
            if (dir == 1) {
                this.drawLineSegment(g, this.toX(p), this.toY(p) + this.getHalfCellSize(), dir, this.getLinkWidth());
            } else if (dir == 0) {
                this.drawLineSegment(g, this.toX(p) + this.getHalfCellSize(), this.toY(p), dir, this.getLinkWidth());
            }
        } else if (n == 2) {
            if (dir == 1) {
                this.drawLineSegment(g, this.toX(p), this.toY(p) + this.getCellSize() / 3, dir, this.getLinkWidth());
                this.drawLineSegment(g, this.toX(p), this.toY(p) + this.getCellSize() - this.getCellSize() / 3, dir, this.getLinkWidth());
            } else if (dir == 0) {
                this.drawLineSegment(g, this.toX(p) + this.getCellSize() / 3, this.toY(p), dir, this.getLinkWidth());
                this.drawLineSegment(g, this.toX(p) + this.getCellSize() - this.getCellSize() / 3, this.toY(p), dir, this.getLinkWidth());
            }
        }
    }
}

