/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.yajilin;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelBase;
import pencilbox.util.Colors;
import pencilbox.yajilin.Board;

public class Panel
extends PanelBase {
    private Board board;
    private boolean indicateErrorMode = false;
    private boolean separateLinkColorMode = false;
    private Color circleColor = new Color(0xFF9999);
    private Color lineColor = new Color(153);
    private Color paintColor = new Color(39423);
    private Color crossColor = new Color(0xFF0099);

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setMarkStyle(3);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public boolean isSeparateLinkColorMode() {
        return this.separateLinkColorMode;
    }

    public void setSeparateLinkColorMode(boolean separateLinkColorMode) {
        this.separateLinkColorMode = separateLinkColorMode;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    public Color getPaintColor() {
        return this.paintColor;
    }

    public void setPaintColor(Color blackColor) {
        this.paintColor = blackColor;
    }

    public Color getCrossColor() {
        return this.crossColor;
    }

    public void setCrossColor(Color crossColor) {
        this.crossColor = crossColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(Color whiteColor) {
        this.circleColor = whiteColor;
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.drawNumbers(g);
        this.drawGrid(g);
        this.drawLinks(g);
        this.drawBoardBorder(g);
    }

    private void drawNumbers(Graphics2D g) {
        g.setFont(this.getNumberFont());
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int state = this.board.getNumber(p);
            if (state == -2) {
                g.setColor(this.getPaintColor());
                this.paintCell(g, p);
            } else if (state == -1) {
                g.setColor(this.getCircleColor());
                this.placeMark(g, p);
            } else if (state >= 0) {
                this.placeArrow(g, p, state);
            } else if (state == -4) {
                g.setColor(this.getNumberColor());
                this.placeBoldCircle(g, p);
            }
            ++n2;
        }
    }

    private void drawLinks(Graphics2D g) {
        SideAddress[] sideAddressArray = this.board.borderAddrs();
        int n = sideAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            SideAddress p = sideAddressArray[n2];
            int state = this.board.getState(p);
            if (state == 1) {
                g.setColor(this.getLineColor());
                if (this.isSeparateLinkColorMode()) {
                    g.setColor(Colors.getColor(this.board.getLink(p).getId()));
                }
                this.placeLink(g, p);
            }
            ++n2;
        }
    }

    private void placeArrow(Graphics2D g, Address p, int arrow) {
        g.setColor(this.getNumberColor());
        if (this.isIndicateErrorMode() && this.board.checkArrow(p) == 16) {
            g.setColor(this.getErrorColor());
        }
        int direction = arrow >> 4 & 3;
        int number = arrow & 0xF;
        String arrowS = this.getArrowString(direction);
        String numberS = Integer.toString(number);
        int r = p.r();
        int c = p.c();
        if (direction == 0 || direction == 2) {
            this.drawString(g, this.toX(c + 1) - this.getCellSize() * 1 / 6, this.toY(r) + this.getHalfCellSize(), arrowS);
            this.drawString(g, this.toX(c) + this.getHalfCellSize() - this.getCellSize() * 1 / 12, this.toY(r) + this.getHalfCellSize(), numberS);
        } else if (direction == 1 || direction == 3) {
            this.drawString(g, this.toX(c) + this.getHalfCellSize(), this.toY(r) + this.getCellSize() * 1 / 6, arrowS);
            this.drawString(g, this.toX(c) + this.getHalfCellSize(), this.toY(r) + this.getHalfCellSize() + this.getCellSize() * 1 / 12, numberS);
        }
    }

    private String getArrowString(int direction) {
        switch (direction) {
            case 0: {
                return "\u2191";
            }
            case 2: {
                return "\u2193";
            }
            case 1: {
                return "\u2190";
            }
            case 3: {
                return "\u2192";
            }
        }
        return "";
    }
}

