/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.yajilin;

import java.awt.Color;
import javax.swing.JMenuItem;
import pencilbox.common.gui.MenuBase;
import pencilbox.resource.Messages;
import pencilbox.yajilin.Panel;

public class Menu
extends MenuBase {
    private JMenuItem numberColorItem;
    private JMenuItem lineColorItem;
    private JMenuItem paintColorItem;
    private JMenuItem circleColorItem;
    private JMenuItem indicateErrorItem;
    private JMenuItem separateLinkColorItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    @Override
    protected void buildEditMenu() {
        this.addSymmetricPlacementMenuItem();
        this.addTrimAnswerMenuItem();
        super.buildEditMenu();
    }

    @Override
    protected void buildViewMenu() {
        this.addNoPaintMarkStyleMenu();
        this.addLinkWidthMenuItem();
        super.buildViewMenu();
        this.numberColorItem = this.addColorMenuItem(Messages.getString("Menu.numberColorItem"));
        this.lineColorItem = this.addColorMenuItem(Messages.getString("Menu.lineColorItem"));
        this.paintColorItem = this.addColorMenuItem(Messages.getString("Menu.paintColorItem"));
        this.circleColorItem = this.addColorMenuItem(Messages.getString("Menu.noPaintColorItem"));
        this.indicateErrorItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.indicateErrorItem"), 'E', false);
        this.addToViewMenu(this.indicateErrorItem);
        this.separateLinkColorItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.separateLinkColorItem"), 'R', false);
        this.addToViewMenu(this.separateLinkColorItem);
        this.addRenewColorMenuItem();
    }

    @Override
    public void executeCommand2(JMenuItem target) {
        if (target == this.indicateErrorItem) {
            this.getPanel().setIndicateErrorMode(target.isSelected());
        } else if (target == this.separateLinkColorItem) {
            this.getPanel().setSeparateLinkColorMode(target.isSelected());
        }
    }

    @Override
    public Color getColor(JMenuItem target) {
        if (target == this.lineColorItem) {
            return this.getPanel().getLineColor();
        }
        if (target == this.paintColorItem) {
            return this.getPanel().getPaintColor();
        }
        if (target == this.circleColorItem) {
            return this.getPanel().getCircleColor();
        }
        if (target == this.numberColorItem) {
            return this.getPanel().getNumberColor();
        }
        return super.getColor(target);
    }

    @Override
    public void setColor(JMenuItem target, Color color) {
        if (target == this.lineColorItem) {
            this.getPanel().setLineColor(color);
        } else if (target == this.paintColorItem) {
            this.getPanel().setPaintColor(color);
        } else if (target == this.circleColorItem) {
            this.getPanel().setCircleColor(color);
        } else if (target == this.numberColorItem) {
            this.getPanel().setNumberColor(color);
        } else {
            super.setColor(target, color);
        }
    }

    @Override
    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.indicateErrorItem.setSelected(this.getPanel().isIndicateErrorMode());
        this.separateLinkColorItem.setSelected(this.getPanel().isSeparateLinkColorMode());
    }
}

