/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slalom;

import java.util.ArrayList;
import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator2;
import pencilbox.common.core.SideAddress;
import pencilbox.slalom.Board;

public class BoardCopier
extends BoardCopierBase {
    @Override
    public void copyRegion(BoardBase srcBoardBase, BoardBase boardBase, Area region, Address from, Address to, int rotation) {
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)boardBase;
        for (Address s : region) {
            Address d = this.translateAndRotateAddress(s, from, to, rotation);
            if (!board.isOn(d)) continue;
            if (srcBoard.getNumber(s) == -4) {
                if (Rotator2.isTransposed(rotation)) {
                    board.changeNumber(d, -5);
                    continue;
                }
                board.changeNumber(d, -4);
                continue;
            }
            if (srcBoard.getNumber(s) == -5) {
                if (Rotator2.isTransposed(rotation)) {
                    board.changeNumber(d, -4);
                    continue;
                }
                board.changeNumber(d, -5);
                continue;
            }
            board.changeNumber(d, srcBoard.getNumber(s));
        }
        ArrayList<SideAddress> list = region.innerBorders();
        for (SideAddress s : list) {
            SideAddress d = Rotator2.translateAndRotateSideAddress(s, from, to, rotation);
            if (!board.isSideOn(d)) continue;
            board.changeState(d, srcBoard.getState(s));
        }
    }

    @Override
    public void eraseRegion(BoardBase srcBoardBase, Area region) {
        Board board = (Board)srcBoardBase;
        ArrayList<SideAddress> list = region.innerBorders();
        for (Comparable<SideAddress> s : list) {
            board.changeState((SideAddress)s, 0);
        }
        for (Comparable<SideAddress> s : region) {
            board.changeNumber((Address)s, -3);
        }
    }
}

