/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.fillomino;

import java.util.LinkedList;
import java.util.List;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BorderEditStep;
import pencilbox.common.core.CellEditStep;
import pencilbox.common.core.SideAddress;
import pencilbox.fillomino.Area;
import pencilbox.resource.Messages;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int BLANK = 0;
    static final int UNKNOWN = 0;
    static final int UNDETERMINED = -2;
    static final int LINE = 1;
    static final int NOLINE = 0;
    private int[][] state;
    private int[][] number;
    private int[][][] edge;
    private Area[][] area;
    private List<Area> areaList;
    private Area initializingArea;

    @Override
    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.number = new int[this.rows()][this.cols()];
        this.edge = new int[2][][];
        this.edge[0] = new int[this.rows()][this.cols() - 1];
        this.edge[1] = new int[this.rows() - 1][this.cols()];
        this.area = new Area[this.rows()][this.cols()];
        this.areaList = new LinkedList<Area>();
    }

    @Override
    public void clearBoard() {
        Comparable<Address> p;
        super.clearBoard();
        Comparable<Address>[] comparableArray = this.cellAddrs();
        int n = comparableArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = comparableArray[n2];
            if (!this.isStable((Address)p)) {
                this.setState((Address)p, 0);
            }
            ++n2;
        }
        comparableArray = this.borderAddrs();
        n = comparableArray.length;
        n2 = 0;
        while (n2 < n) {
            p = comparableArray[n2];
            this.setEdge((SideAddress)p, 0);
            ++n2;
        }
        this.initBoard();
    }

    @Override
    public void trimAnswer() {
        SideAddress[] sideAddressArray = this.borderAddrs();
        int n = sideAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            SideAddress p = sideAddressArray[n2];
            if (this.getEdge(p) == 1) {
                this.changeEdge(p, 0);
            }
            ++n2;
        }
    }

    int[][] getNumber() {
        return this.number;
    }

    int[][] getState() {
        return this.state;
    }

    public boolean isStable(int r, int c) {
        return this.number[r][c] != 0;
    }

    public boolean isStable(Address p) {
        return this.isStable(p.r(), p.c());
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public int getState(Address p) {
        return this.getState(p.r(), p.c());
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public void setState(Address p, int st) {
        this.setState(p.r(), p.c(), st);
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address p) {
        return this.getNumber(p.r(), p.c());
    }

    public int getNumberOrState(Address p) {
        return this.isStable(p) ? this.getNumber(p) : this.getState(p);
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public void setNumber(Address p, int n) {
        this.setNumber(p.r(), p.c(), n);
    }

    public int getEdge(SideAddress p) {
        return this.edge[p.d()][p.r()][p.c()];
    }

    public void setEdge(SideAddress p, int n) {
        this.edge[p.d()][p.r()][p.c()] = n;
    }

    @Override
    public void initBoard() {
        this.initAreas();
    }

    public void initAreas() {
        ArrayUtil.initArrayObject2(this.area, null);
        this.areaList.clear();
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getNumberOrState(p) > 0 && this.getArea(p) == null) {
                this.initArea(p);
            }
            ++n2;
        }
    }

    void initArea(Address p) {
        this.initializingArea = new Area(this.getNumberOrState(p));
        this.initArea1(p);
        this.areaList.add(this.initializingArea);
    }

    private void initArea1(Address p) {
        if (!this.isOn(p)) {
            return;
        }
        if (this.getArea(p) == this.initializingArea) {
            return;
        }
        if (this.getNumberOrState(p) != this.initializingArea.getNumber()) {
            return;
        }
        this.initializingArea.add(p);
        this.setArea(p, this.initializingArea);
        int d = 0;
        while (d < 4) {
            Address p1 = Address.nextCell(p, d);
            this.initArea1(p1);
            ++d;
        }
    }

    public Area getArea(Address p) {
        if (!this.isOn(p)) {
            return null;
        }
        return this.area[p.r()][p.c()];
    }

    public void setArea(Address p, Area a) {
        this.area[p.r()][p.c()] = a;
    }

    public void changeAnswerNumber(Address p, int n) {
        int prev = this.getState(p);
        if (n == prev) {
            return;
        }
        if (this.isStable(p)) {
            this.changeFixedNumber(p, 0);
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.NUMBER, p, prev, n));
        }
        this.setState(p, n);
        this.changeNumber1(p, prev, n);
    }

    public void changeFixedNumber(Address p, int n) {
        int prev = this.getNumber(p);
        if (n == prev) {
            return;
        }
        if (this.getState(p) > 0) {
            this.changeAnswerNumber(p, 0);
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new CellEditStep(AbstractStep.EditType.FIXED, p, prev, n));
        }
        this.setNumber(p, n);
        this.changeNumber1(p, prev, n);
    }

    private void changeNumber1(Address p, int prev, int n) {
        if (prev > 0) {
            this.splitArea(p, prev);
        }
        if (n > 0) {
            this.mergeArea(p, n);
        }
    }

    public void changeEdge(SideAddress p, int st) {
        int prev = this.getEdge(p);
        if (prev == st) {
            return;
        }
        if (this.isRecordUndo()) {
            this.fireUndoableEditUpdate(new BorderEditStep(p, prev, st));
        }
        this.setEdge(p, st);
    }

    @Override
    public void undo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            if (s.getType() == AbstractStep.EditType.NUMBER) {
                this.changeAnswerNumber(s.getPos(), s.getBefore());
            } else if (s.getType() == AbstractStep.EditType.FIXED) {
                this.changeFixedNumber(s.getPos(), s.getBefore());
            }
        } else if (step instanceof BorderEditStep) {
            BorderEditStep s = (BorderEditStep)step;
            this.changeEdge(s.getPos(), s.getBefore());
        }
    }

    @Override
    public void redo(AbstractStep step) {
        if (step instanceof CellEditStep) {
            CellEditStep s = (CellEditStep)step;
            if (s.getType() == AbstractStep.EditType.NUMBER) {
                this.changeAnswerNumber(s.getPos(), s.getAfter());
            } else if (s.getType() == AbstractStep.EditType.FIXED) {
                this.changeFixedNumber(s.getPos(), s.getAfter());
            }
        } else if (step instanceof BorderEditStep) {
            BorderEditStep s = (BorderEditStep)step;
            this.changeEdge(s.getPos(), s.getAfter());
        }
    }

    void mergeArea(Address p, int number) {
        pencilbox.common.core.Area mergedArea = null;
        int d = 0;
        while (d < 4) {
            mergedArea = this.mergeArea1(this.getArea(Address.nextCell(p, d)), (Area)mergedArea, number);
            ++d;
        }
        if (mergedArea == null) {
            mergedArea = new Area(number);
            this.areaList.add((Area)mergedArea);
        }
        mergedArea.add(p);
        this.setArea(p, (Area)mergedArea);
    }

    private Area mergeArea1(Area area, Area mergedArea, int number) {
        if (area != null && area.getNumber() == number) {
            if (mergedArea == null) {
                mergedArea = area;
            } else if (mergedArea != area) {
                mergedArea.addAll(area);
                for (Address p : area) {
                    this.setArea(p, mergedArea);
                }
                this.areaList.remove(area);
            }
        }
        return mergedArea;
    }

    void splitArea(Address p0, int number) {
        this.areaList.remove(this.getArea(p0));
        for (Address p : this.getArea(p0)) {
            this.setArea(p, null);
        }
        int d = 0;
        while (d < 4) {
            Address p = Address.nextCell(p0, d);
            if (this.isOn(p) && this.getNumberOrState(p) == number && this.getArea(p) == null) {
                this.initArea(p);
            }
            ++d;
        }
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        Address[] addressArray = this.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.getNumberOrState(p) <= 0) {
                result |= 1;
            }
            ++n2;
        }
        for (Area area : this.areaList) {
            int status = area.getStatus();
            if (status == -1) {
                result |= 2;
                continue;
            }
            if (status != 0) continue;
            result |= 4;
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        if (result == 1) {
            return Messages.getString("fillomino.AnswerCheckMessage1");
        }
        StringBuffer message = new StringBuffer();
        if ((result & 2) == 2) {
            message.append(Messages.getString("fillomino.AnswerCheckMessage2"));
        }
        if ((result & 4) == 4) {
            message.append(Messages.getString("fillomino.AnswerCheckMessage3"));
        }
        return message.toString();
    }
}

