/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hitori;

import java.awt.Color;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import pencilbox.common.gui.MenuBase;
import pencilbox.hitori.Letters;
import pencilbox.hitori.Panel;
import pencilbox.resource.Messages;

public class Menu
extends MenuBase {
    private JMenuItem selectLetterItem;
    private JMenuItem numberColorItem;
    private JMenuItem paintColorItem;
    private JMenuItem circleColorItem;
    private JMenuItem indicateErrorItem;
    private JMenuItem hideSoleNumberItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    @Override
    protected void buildEditMenu() {
        this.addTrimAnswerMenuItem();
        super.buildEditMenu();
    }

    @Override
    protected void buildViewMenu() {
        this.addNoPaintMarkStyleMenu();
        super.buildViewMenu();
        this.numberColorItem = this.addColorMenuItem(Messages.getString("Menu.numberColorItem"));
        this.paintColorItem = this.addColorMenuItem(Messages.getString("Menu.paintColorItem"));
        this.circleColorItem = this.addColorMenuItem(Messages.getString("Menu.noPaintColorItem"));
        this.selectLetterItem = this.makeCommandMenuItem(Messages.getString("Menu.selectLetterItem"), 'T');
        this.addToViewMenu(this.selectLetterItem);
        this.indicateErrorItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.indicateErrorItem"), 'E', false);
        this.addToViewMenu(this.indicateErrorItem);
        this.hideSoleNumberItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.hideSoleNumberItem"), 'H', false);
        this.addToViewMenu(this.hideSoleNumberItem);
    }

    @Override
    public void executeCommand2(JMenuItem target) {
        if (target == this.indicateErrorItem) {
            this.getPanel().setIndicateErrorMode(target.isSelected());
        } else if (target == this.hideSoleNumberItem) {
            this.getPanel().setHideSoleNumberMode(target.isSelected());
        } else if (target == this.selectLetterItem) {
            this.selectLetter();
        }
    }

    @Override
    public Color getColor(JMenuItem target) {
        if (target == this.paintColorItem) {
            return this.getPanel().getPaintColor();
        }
        if (target == this.circleColorItem) {
            return this.getPanel().getCircleColor();
        }
        if (target == this.numberColorItem) {
            return this.getPanel().getNumberColor();
        }
        return super.getColor(target);
    }

    @Override
    public void setColor(JMenuItem target, Color color) {
        if (target == this.paintColorItem) {
            this.getPanel().setPaintColor(color);
        } else if (target == this.circleColorItem) {
            this.getPanel().setCircleColor(color);
        } else if (target == this.numberColorItem) {
            this.getPanel().setNumberColor(color);
        } else {
            super.setColor(target, color);
        }
    }

    void selectLetter() {
        Object[] options = new String[]{"1", "A", "\u0391", "\u0410", "\u30a2", "\u3044", "\u2606", "\u9c78"};
        String message = "";
        String title = Messages.getString("Menu.SelectLetterDialog");
        int selection = JOptionPane.showOptionDialog(null, message, title, -1, -1, null, options, options[0]);
        if (selection == -1) {
            return;
        }
        this.getPanel().setLetters(Letters.getLetterSeries(selection));
    }

    @Override
    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.indicateErrorItem.setSelected(this.getPanel().isIndicateErrorMode());
        this.hideSoleNumberItem.setSelected(this.getPanel().isHideSoleNumberMode());
    }
}

