/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slitherlink;

import java.util.ArrayList;
import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator;
import pencilbox.common.core.Rotator2;
import pencilbox.common.core.SideAddress;
import pencilbox.slitherlink.Board;

public class BoardCopier
extends BoardCopierBase {
    @Override
    public void copyBoardStates(BoardBase src, BoardBase dst, int n) {
        Board s = (Board)src;
        Board d = (Board)dst;
        Rotator rotator = new Rotator(src.getSize(), n);
        rotator.rotateArrayInt3(s.getState(), d.getState());
        Rotator rotator2 = new Rotator(src.rows() - 1, src.cols() - 1, n);
        rotator2.rotateArrayInt2(s.getNumber(), d.getNumber());
    }

    @Override
    public void copyRegion(BoardBase srcBoardBase, BoardBase boardBase, Area region, Address from, Address to, int rotation) {
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)boardBase;
        for (Address s : region) {
            Address dnrt;
            Address rt;
            Address d = this.translateAndRotateAddress(s, from, to, rotation);
            Address dn = Address.nextCell(s, 2);
            if (!region.containsAll(dn, rt = Address.nextCell(s, 3), dnrt = Address.nextCell(dn, 3))) continue;
            int grid = srcBoard.getNumber(s);
            Address dd = null;
            if (rotation == 0 || rotation == 4) {
                dd = d;
            } else if (rotation == 1 || rotation == 7) {
                dd = Address.address(d.r() - 1, d.c());
            } else if (rotation == 2 || rotation == 6) {
                dd = Address.address(d.r() - 1, d.c() - 1);
            } else if (rotation == 3 || rotation == 5) {
                dd = Address.address(d.r(), d.c() - 1);
            }
            if (!board.isNumberOn(dd)) continue;
            board.changeNumber(dd, grid);
        }
        ArrayList<SideAddress> list = region.innerBorders();
        for (SideAddress s : list) {
            SideAddress d = Rotator2.translateAndRotateSideAddress(s, from, to, rotation);
            if (!board.isSideOn(d)) continue;
            board.changeState(d, srcBoard.getState(s));
        }
    }

    @Override
    public void eraseRegion(BoardBase boardBase, Area region) {
        Board board = (Board)boardBase;
        ArrayList<SideAddress> list = region.innerBorders();
        for (Comparable<SideAddress> s : list) {
            board.changeState((SideAddress)s, 0);
        }
        for (Comparable<SideAddress> s : region) {
            Address dn = Address.nextCell((Address)s, 2);
            Address rt = Address.nextCell((Address)s, 3);
            Address dnrt = Address.nextCell(dn, 3);
            if (!region.containsAll(dn, rt, dnrt)) continue;
            board.changeNumber((Address)s, -1);
        }
    }
}

