/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shikaku;

import java.util.ArrayList;
import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator2;
import pencilbox.common.core.SideAddress;
import pencilbox.shikaku.Board;
import pencilbox.shikaku.Square;

public class BoardCopier
extends BoardCopierBase {
    @Override
    public void copyRegion(BoardBase srcBoardBase, BoardBase boardBase, Area region, Address from, Address to, int rotation) {
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)boardBase;
        for (Address s : region) {
            Address d = this.translateAndRotateAddress(s, from, to, rotation);
            if (!boardBase.isOn(d)) continue;
            board.changeNumber(d, srcBoard.getNumber(s));
        }
        for (Address s : region) {
            Address d1;
            Address d0;
            Square dstSquare;
            Square srcSquare = srcBoard.getSquare(s);
            if (srcSquare == null || !s.equals(srcSquare.p0()) || !region.containsAll(srcSquare.getCorners()) || !boardBase.isOnAll((dstSquare = new Square(d0 = this.translateAndRotateAddress(srcSquare.p0(), from, to, rotation), d1 = this.translateAndRotateAddress(srcSquare.p1(), from, to, rotation))).getCorners())) continue;
            board.removeOverlappedSquares(dstSquare, null);
            board.addSquare(dstSquare);
        }
        ArrayList<SideAddress> innerBorders = region.innerBorders();
        for (SideAddress s : innerBorders) {
            SideAddress d = Rotator2.translateAndRotateSideAddress(s, from, to, rotation);
            if (!boardBase.isSideOn(d)) continue;
            board.changeEdge(d, srcBoard.getEdge(s));
        }
    }

    @Override
    public void eraseRegion(BoardBase boardBase, Area region) {
        Board board = (Board)boardBase;
        for (Address s : region) {
            Square square = board.getSquare(s);
            if (square == null || !s.equals(square.p0()) || !region.containsAll(square.getCorners())) continue;
            board.removeSquare(square);
        }
        ArrayList<SideAddress> innerBorders = region.innerBorders();
        for (Comparable<SideAddress> s : innerBorders) {
            board.changeEdge((SideAddress)s, 0);
        }
        for (Comparable<SideAddress> s : region) {
            board.changeNumber((Address)s, 0);
        }
    }
}

