/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.goishi;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.goishi.Board;

public class Panel
extends PanelBase {
    private Board board;
    private Color inputColor = new Color(153);
    private Color paintColor = new Color(0xFFFFFF);

    public Panel() {
        this.setGridColor(Color.GRAY);
        this.setGridStyle(1);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getInputColor() {
        return this.inputColor;
    }

    public void setInputColor(Color inputColor) {
        this.inputColor = inputColor;
    }

    public Color getPaintColor() {
        return this.paintColor;
    }

    public void setPaintColor(Color paintColor) {
        this.paintColor = paintColor;
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.drawGrid(g);
        this.drawNumbers(g);
    }

    @Override
    public void drawGrid(Graphics2D g) {
        g.setColor(this.getGridColor());
        int style = this.getGridStyle();
        if (style == 0) {
            return;
        }
        int r = 0;
        while (r < this.rows()) {
            g.drawLine(this.toX(0) + this.getHalfCellSize(), this.toY(r) + this.getHalfCellSize(), this.toX(this.cols()) - this.getHalfCellSize(), this.toY(r) + this.getHalfCellSize());
            ++r;
        }
        int c = 0;
        while (c < this.cols()) {
            g.drawLine(this.toX(c) + this.getHalfCellSize(), this.toY(0) + this.getHalfCellSize(), this.toX(c) + this.getHalfCellSize(), this.toY(this.rows()) - this.getHalfCellSize());
            ++c;
        }
    }

    private void drawNumbers(Graphics2D g) {
        g.setFont(this.getNumberFont());
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.board.getState(p) == -1) {
                g.setColor(this.getPaintColor());
                this.placeFilledCircle(g, p);
                int n3 = this.board.getNumber(p);
                if (n3 > 0) {
                    g.setColor(this.getInputColor());
                    this.placeNumber(g, p, n3);
                } else {
                    g.setColor(this.getNumberColor());
                    this.placeBoldCircle(g, p);
                }
            }
            ++n2;
        }
    }
}

