/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.goishi;

import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator;
import pencilbox.goishi.Board;

public class BoardCopier
extends BoardCopierBase {
    @Override
    public void copyBoardStates(BoardBase src, BoardBase dst, int n) {
        Board srcBoard = (Board)src;
        Board board = (Board)dst;
        Rotator rotator = new Rotator(src.getSize(), n);
        Address[] addressArray = src.cellAddrs();
        int n2 = addressArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Address s = addressArray[n3];
            Address d = rotator.rotateAddress(s);
            if (board.isOn(d)) {
                board.setState(d, srcBoard.getState(s));
            }
            ++n3;
        }
        int i = 0;
        while (i < srcBoard.pickedList.size()) {
            Address d = rotator.rotateAddress(srcBoard.pickedList.get(i));
            board.pickedList.add(d);
            board.setNumber(d, i + 1);
            ++i;
        }
    }

    @Override
    public void copyRegion(BoardBase srcBoardBase, BoardBase boardBase, Area region, Address from, Address to, int rotation) {
        Address d;
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)boardBase;
        for (Address s : region) {
            d = this.translateAndRotateAddress(s, from, to, rotation);
            if (!board.isOn(d)) continue;
            board.changeState(d, srcBoard.getState(s));
        }
        int i = 0;
        while (i < srcBoard.pickedList.size()) {
            Address s = srcBoard.pickedList.get(i);
            if (region.contains(s) && board.isOn(d = this.translateAndRotateAddress(s, from, to, rotation)) && board.canPick(d)) {
                board.pickUp(d);
            }
            ++i;
        }
    }

    @Override
    public void eraseRegion(BoardBase boardBase, Area region) {
        Board board = (Board)boardBase;
        for (Address s : region) {
            board.changeState(s, 0);
        }
    }
}

