/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.sudoku;

import pencilbox.common.core.Address;
import pencilbox.sudoku.Board;

public class DigitPatternHint {
    private int allDigitPattern = 1022;
    private Board board;
    private int[][] pattern;

    int getPattern(Address p) {
        return this.pattern[p.r()][p.c()];
    }

    void setupHint(Board board) {
        this.board = board;
        this.pattern = new int[board.rows()][board.cols()];
        int maxNumber = board.rows();
        this.allDigitPattern = ~((-1 << maxNumber + 1) + 1);
    }

    void initHint() {
        Address p;
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            this.pattern[p.r()][p.c()] = this.allDigitPattern;
            ++n2;
        }
        addressArray = this.board.cellAddrs();
        n = addressArray.length;
        n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            int n3 = this.board.getNumberOrState(p);
            if (n3 > 0) {
                this.checkUsedNumber(p, n3);
            }
            ++n2;
        }
    }

    boolean canPlace(Address p, int n) {
        return (this.pattern[p.r()][p.c()] & 1 << n) > 0;
    }

    void checkUsedNumber(Address p0, int n) {
        int unit = this.board.getUnit();
        int pat = ~(1 << n);
        int cc = 0;
        while (cc < this.board.cols()) {
            int[] nArray = this.pattern[p0.r()];
            int n2 = cc++;
            nArray[n2] = nArray[n2] & pat;
        }
        int rr = 0;
        while (rr < this.board.rows()) {
            int[] nArray = this.pattern[rr];
            int n3 = p0.c();
            nArray[n3] = nArray[n3] & pat;
            ++rr;
        }
        int boxR = p0.r() / unit * unit;
        int boxC = p0.c() / unit * unit;
        int rr2 = 0;
        while (rr2 < unit) {
            int cc2 = 0;
            while (cc2 < unit) {
                int[] nArray = this.pattern[boxR + rr2];
                int n4 = boxC + cc2;
                nArray[n4] = nArray[n4] & pat;
                ++cc2;
            }
            ++rr2;
        }
    }

    void updateHint(Address p0, int n) {
        int prev = this.board.getNumberOrState(p0);
        if (prev > 0) {
            this.deleteHint(p0, prev);
        }
        if (n > 0) {
            this.checkUsedNumber(p0, n);
        }
    }

    void deleteHint(Address p0, int n0) {
        Address p;
        int pat = 1 << n0;
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            int[] nArray = this.pattern[p.r()];
            int n3 = p.c();
            nArray[n3] = nArray[n3] | pat;
            ++n2;
        }
        addressArray = this.board.cellAddrs();
        n = addressArray.length;
        n2 = 0;
        while (n2 < n) {
            p = addressArray[n2];
            int n4 = this.board.getNumberOrState(p);
            if (n4 == n0 && !p.equals(p0)) {
                this.checkUsedNumber(p, n4);
            }
            ++n2;
        }
    }
}

