/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.io;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Problem;
import pencilbox.common.core.Property;
import pencilbox.common.factory.PencilType;

public abstract class PclWriterBase {
    private Document doc;
    private DocumentBuilder builder;
    private BoardBase board;
    private PencilType pencilType;

    public void setPuzzleType(PencilType pt) {
        this.pencilType = pt;
    }

    public void writeProblem(File file, Problem problem) throws TransformerException {
        Document doc = this.buildDocument(problem);
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("indent", "yes");
        t.transform(new DOMSource(doc), new StreamResult(file));
    }

    public Document buildDocument(Problem problem) {
        Element element;
        this.board = problem.getBoard();
        Property property = problem.getProperty();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.doc = this.builder.newDocument();
        Element puzzleElement = this.doc.createElement("puzzle");
        this.doc.appendChild(puzzleElement);
        Element typeElement = this.doc.createElement("type");
        typeElement.setTextContent(this.pencilType.getPencilName());
        puzzleElement.appendChild(typeElement);
        Element sizeElement = this.doc.createElement("size");
        sizeElement.setTextContent(this.makeSizeText());
        puzzleElement.appendChild(sizeElement);
        Element questionElement = this.doc.createElement("question");
        questionElement.setTextContent(this.makeQuestionText());
        puzzleElement.appendChild(questionElement);
        Element answerElement = this.doc.createElement("answer");
        answerElement.setTextContent(this.makeAnswerText());
        puzzleElement.appendChild(answerElement);
        String str = property.getAuthor();
        if (str.trim().length() > 0) {
            element = this.doc.createElement("author");
            element.setTextContent(str);
            puzzleElement.appendChild(element);
        }
        if ((str = property.getDifficulty()).trim().length() > 0) {
            element = this.doc.createElement("difficulty");
            element.setTextContent(str);
            puzzleElement.appendChild(element);
        }
        if ((str = property.getSource()).trim().length() > 0) {
            element = this.doc.createElement("source");
            element.setTextContent(str);
            puzzleElement.appendChild(element);
        }
        return this.doc;
    }

    protected String makeSizeText() {
        return String.valueOf(this.board.rows()) + " " + this.board.cols();
    }

    protected String makeQuestionText() {
        return "";
    }

    protected String makeAnswerText() {
        return "";
    }

    protected BoardBase getBoard() {
        return this.board;
    }
}

