/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;
import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.core.Size;
import pencilbox.common.core.Square;
import pencilbox.common.gui.CellCursor;

public class PanelBase
extends JPanel
implements Printable {
    public static int ANSWER_INPUT_MODE = 0;
    public static int PROBLEM_INPUT_MODE = 1;
    public static int REGION_EDIT_MODE = 3;
    private Size size;
    private int cellSize = 26;
    private int circleSize = 18;
    private int smallCrossSize = 3;
    private int linkWidth = 3;
    private int offsetx = 10;
    private int offsety = 10;
    private Color backgroundColor = Color.WHITE;
    private Color boardBorderColor = Color.BLACK;
    private Color gridColor = Color.BLACK;
    private Color numberColor = Color.BLACK;
    private Color indexColor = Color.BLACK;
    private Color errorColor = Color.RED;
    private Color cursorColor = new Color(0xFF0000);
    private Color answerCursorColor = new Color(255);
    private Font indexFont = new Font("SansSerif", 2, 13);
    private Font numberFont = new Font("SansSerif", 0, 20);
    private int gridStyle = 1;
    private int markStyle = 1;
    private boolean indexMode = false;
    private boolean cursorMode = false;
    private CellCursor cellCursor;
    private Area copyRegion = new Area();
    private Area pasteRegion = new Area();
    private Color copyRegionColor = new Color(0xFF0000);
    private Color pasteRegionColor = new Color(0xFFAAAA);
    private int editMode = 0;

    public PanelBase() {
        this.setFocusable(true);
    }

    public void setup(BoardBase board) {
        this.size = board.getSize();
        this.updatePreferredSize();
        this.setBoard(board);
        this.cellCursor = this.createCursor();
    }

    public CellCursor createCursor() {
        return new CellCursor();
    }

    protected void setBoard(BoardBase board) {
    }

    public void setDisplaySize(int cellSize) {
        this.cellSize = cellSize;
        if (this.indexMode) {
            this.offsetx = cellSize;
            this.offsety = cellSize;
        }
        this.circleSize = (int)((double)cellSize * 0.7);
        this.smallCrossSize = (int)((double)cellSize * 0.15);
        this.numberFont = new Font("SansSerif", 0, cellSize * 4 / 5);
        this.indexFont = new Font("SansSerif", 2, cellSize / 2);
        this.updatePreferredSize();
        this.repaint();
    }

    protected int getGridStyle() {
        return this.gridStyle;
    }

    protected void setGridStyle(int i) {
        this.gridStyle = i;
    }

    public int getMarkStyle() {
        return this.markStyle;
    }

    public void setMarkStyle(int markStyle) {
        this.markStyle = markStyle;
    }

    protected void updatePreferredSize() {
        this.setPreferredSize(this.getBoardRegionSize());
        this.revalidate();
    }

    public Dimension getBoardRegionSize() {
        return new Dimension(this.offsetx * 2 + this.cellSize * this.cols() + 1, this.offsety * 2 + this.cellSize * this.rows() + 1);
    }

    public boolean isProblemEditMode() {
        return this.editMode == PROBLEM_INPUT_MODE;
    }

    public int getEditMode() {
        return this.editMode;
    }

    public void setEditMode(int editMode) {
        this.editMode = editMode;
    }

    public int rows() {
        return this.size.getRows();
    }

    public int cols() {
        return this.size.getCols();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawPanel((Graphics2D)g);
    }

    public void drawPanel(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.paintBackground(g);
        this.drawBoard(g);
        if (this.editMode == REGION_EDIT_MODE) {
            this.drawCopyPasteRegion(g);
        } else {
            this.drawCursor(g);
        }
        this.drawIndex(g);
    }

    public void drawBoard(Graphics2D g) {
    }

    public final int toX(int c) {
        return this.getOffsetx() + this.getCellSize() * c;
    }

    public final int toX(Address p) {
        return this.toX(p.c());
    }

    public final int toY(int r) {
        return this.getOffsety() + this.getCellSize() * r;
    }

    public final int toY(Address p) {
        return this.toY(p.r());
    }

    private final int toC(int x) {
        return (x + this.getCellSize() - this.getOffsetx()) / this.getCellSize() - 1;
    }

    private final int toR(int y) {
        return (y + this.getCellSize() - this.getOffsety()) / this.getCellSize() - 1;
    }

    public Address pointToAddress(int x, int y) {
        int r = this.toR(y);
        int c = this.toC(x);
        return Address.address(r, c);
    }

    public SideAddress pointToSideAddress(int x, int y) {
        int resy;
        int r = this.toR(y);
        int c = this.toC(x);
        int resx = x - this.getOffsetx() - this.getCellSize() * c;
        if (resx + (resy = y - this.getOffsety() - this.getCellSize() * r) < this.getCellSize()) {
            if (resx < resy) {
                return SideAddress.sideAddress(0, r, c - 1);
            }
            return SideAddress.sideAddress(1, r - 1, c);
        }
        if (resy < resx) {
            return SideAddress.sideAddress(0, r, c);
        }
        return SideAddress.sideAddress(1, r, c);
    }

    public void paintBackground(Graphics2D g) {
        g.setColor(this.backgroundColor);
        g.fillRect(this.offsetx, this.offsety, this.cellSize * this.cols(), this.cellSize * this.rows());
    }

    public void drawBoardBorder(Graphics2D g) {
        g.setColor(this.boardBorderColor);
        int i = 0;
        while (i <= 1) {
            g.drawRect(this.offsetx - i, this.offsety - i, this.cellSize * this.cols() + i + i, this.cellSize * this.rows() + i + i);
            ++i;
        }
    }

    public void drawGrid(Graphics2D g) {
        if (this.getGridStyle() == 0) {
            return;
        }
        g.setColor(this.gridColor);
        int r = 1;
        while (r < this.rows()) {
            g.drawLine(this.toX(0), this.toY(r), this.toX(this.cols()), this.toY(r));
            ++r;
        }
        int c = 1;
        while (c < this.cols()) {
            g.drawLine(this.toX(c), this.toY(0), this.toX(c), this.toY(this.rows()));
            ++c;
        }
    }

    public void drawIndex(Graphics2D g) {
        int firstIndex = 1;
        g.setFont(this.indexFont);
        g.setColor(this.indexColor);
        if (!this.isIndexMode()) {
            return;
        }
        int r = 0;
        while (r < this.rows()) {
            this.placeIndexNumber(g, r, -1, r + firstIndex);
            ++r;
        }
        int c = 0;
        while (c < this.cols()) {
            this.placeIndexNumber(g, -1, c, c + firstIndex);
            ++c;
        }
    }

    public void drawCursor(Graphics2D g) {
        if (this.isProblemEditMode()) {
            g.setColor(this.cursorColor);
        } else if (this.isCursorMode()) {
            g.setColor(this.answerCursorColor);
        } else {
            return;
        }
        int i = 0;
        while (i <= 2) {
            g.drawRect(this.toX(this.cellCursor.c()) + i, this.toY(this.cellCursor.r()) + i, this.cellSize - i - i, this.cellSize - i - i);
            ++i;
        }
    }

    public void drawLineSegment(Graphics g, int x, int y, int direction, int w) {
        if (w == 1) {
            if (direction == 1) {
                g.fillRect(x - w / 2, y - w / 2, this.cellSize + w, w);
            } else if (direction == 0) {
                g.fillRect(x - w / 2, y - w / 2, w, this.cellSize + w);
            }
        } else if (w > 1) {
            if (direction == 1) {
                g.fillRect(x - (w - 2) / 2, y - w / 2, this.cellSize + w - 2, w);
            } else if (direction == 0) {
                g.fillRect(x - w / 2, y - (w - 2) / 2, w, this.cellSize + w - 2);
            }
        }
    }

    public void drawLineSegment(Graphics g, int x, int y, int direction) {
        this.drawLineSegment(g, x, y, direction, 3);
    }

    public void fillSquare(Graphics g, int x, int y, int halfSize) {
        g.fillRect(x - halfSize, y - halfSize, halfSize + halfSize + 1, halfSize + halfSize + 1);
    }

    public void drawCross(Graphics g, int x, int y, int halfSize) {
        g.drawLine(x - halfSize, y - halfSize, x + halfSize, y + halfSize);
        g.drawLine(x - halfSize, y + halfSize, x + halfSize, y - halfSize);
    }

    public void drawCircle(Graphics g, int x, int y, int radius) {
        g.drawOval(x - radius, y - radius, radius + radius, radius + radius);
    }

    public void fillCircle(Graphics g, int x, int y, int radius) {
        g.fillOval(x - radius, y - radius, radius + radius + 1, radius + radius + 1);
    }

    public void drawString(Graphics g, int x, int y, String str) {
        FontMetrics metrics = g.getFontMetrics();
        g.drawString(str, x - metrics.stringWidth(str) / 2, y - metrics.getHeight() / 2 + metrics.getAscent());
    }

    public void placeString(Graphics2D g, int r, int c, String string) {
        this.drawString(g, this.toX(c) + this.getHalfCellSize(), this.toY(r) + this.getHalfCellSize(), string);
    }

    public void placeLetter(Graphics2D g, int r, int c, char letter) {
        this.placeString(g, r, c, Character.toString(letter));
    }

    public void placeLetter(Graphics2D g, Address p, char letter) {
        this.placeLetter(g, p.r(), p.c(), letter);
    }

    public void placeNumber(Graphics2D g, int r, int c, int number) {
        this.placeString(g, r, c, Integer.toString(number));
    }

    public void placeNumber(Graphics2D g, Address p, int number) {
        this.placeNumber(g, p.r(), p.c(), number);
    }

    public void placeIndexNumber(Graphics2D g, int r, int c, int number) {
        this.placeString(g, r, c, Integer.toString(number));
    }

    public void paintCell(Graphics2D g, int r, int c) {
        g.fillRect(this.toX(c), this.toY(r), this.getCellSize(), this.getCellSize());
    }

    public void paintCell(Graphics2D g, Address p) {
        this.paintCell(g, p.r(), p.c());
    }

    public void placeCircle(Graphics2D g, int r, int c) {
        this.placeCircle(g, r, c, this.getCircleSize());
    }

    public void placeCircle(Graphics2D g, Address p) {
        this.placeCircle(g, p.r(), p.c(), this.getCircleSize());
    }

    public void placeCircle(Graphics2D g, int r, int c, int circleSize) {
        this.drawCircle(g, this.toX(c) + this.getHalfCellSize(), this.toY(r) + this.getHalfCellSize(), circleSize / 2);
    }

    public void placeCircle(Graphics2D g, Address p, int circleSize) {
        this.placeCircle(g, p.r(), p.c(), circleSize);
    }

    public void placeBoldCircle(Graphics2D g, int r, int c) {
        this.placeBoldCircle(g, r, c, this.getCircleSize());
    }

    public void placeBoldCircle(Graphics2D g, Address p) {
        this.placeBoldCircle(g, p.r(), p.c(), this.getCircleSize());
    }

    public void placeBoldCircle(Graphics2D g, int r, int c, int circleSize) {
        int x = this.toX(c) + this.getHalfCellSize();
        int y = this.toY(r) + this.getHalfCellSize();
        this.drawCircle(g, x, y, circleSize / 2);
        this.drawCircle(g, x, y, circleSize / 2 - 1);
    }

    public void placeFilledCircle(Graphics2D g, int r, int c) {
        this.placeFilledCircle(g, r, c, this.getCircleSize());
    }

    public void placeFilledCircle(Graphics2D g, Address p) {
        this.placeFilledCircle(g, p.r(), p.c(), this.getCircleSize());
    }

    public void placeFilledCircle(Graphics2D g, int r, int c, int circleSize) {
        this.fillCircle(g, this.toX(c) + this.getHalfCellSize(), this.toY(r) + this.getHalfCellSize(), circleSize / 2);
    }

    public void placeFilledCircle(Graphics2D g, Address p, int circleSize) {
        this.placeFilledCircle(g, p.r(), p.c(), circleSize);
    }

    public void placeFilledSquare(Graphics2D g, int r, int c) {
        this.fillSquare(g, this.toX(c) + this.getHalfCellSize(), this.toY(r) + this.getHalfCellSize(), this.getSmallCrossSize());
    }

    public void placeCross(Graphics2D g, int r, int c) {
        this.drawCross(g, this.toX(c) + this.getHalfCellSize(), this.toY(r) + this.getHalfCellSize(), this.getSmallCrossSize());
    }

    public void placeCross(Graphics2D g, Address p) {
        this.placeCross(g, p.r(), p.c());
    }

    public void placeSideLine(Graphics2D g, int d, int r, int c, int w) {
        if (d == 0) {
            this.drawLineSegment(g, this.toX(c + 1), this.toY(r), d, w);
        } else if (d == 1) {
            this.drawLineSegment(g, this.toX(c), this.toY(r + 1), d, w);
        }
    }

    public void placeSideLine(Graphics2D g, SideAddress p, int w) {
        this.placeSideLine(g, p.d(), p.r(), p.c(), w);
    }

    public void placeSideLine(Graphics2D g, SideAddress p) {
        this.placeSideLine(g, p, 3);
    }

    public void placeLink(Graphics2D g, int d, int r, int c) {
        this.drawLineSegment(g, this.toX(c) + this.getHalfCellSize(), this.toY(r) + this.getHalfCellSize(), d ^ 1, this.getLinkWidth());
    }

    public void placeLink(Graphics2D g, SideAddress p) {
        this.placeLink(g, p.d(), p.r(), p.c());
    }

    public void placeSideCross(Graphics2D g, int d, int r, int c) {
        if (d == 0) {
            this.drawCross(g, this.toX(c + 1), this.toY(r) + this.getHalfCellSize(), this.smallCrossSize);
        } else if (d == 1) {
            this.drawCross(g, this.toX(c) + this.getHalfCellSize(), this.toY(r + 1), this.smallCrossSize);
        }
    }

    public void placeSideCross(Graphics2D g, SideAddress p) {
        this.placeSideCross(g, p.d(), p.r(), p.c());
    }

    public void placeCenterLine(Graphics2D g, int r, int c, int dir) {
        if (dir == 1) {
            this.drawLineSegment(g, this.toX(c), this.toY(r) + this.getHalfCellSize(), dir, 1);
        } else if (dir == 0) {
            this.drawLineSegment(g, this.toX(c) + this.getHalfCellSize(), this.toY(r), dir, 1);
        }
    }

    public void placeCenterLine(Graphics2D g, Address p, int dir) {
        this.placeCenterLine(g, p.r(), p.c(), dir);
    }

    public void placeSquare(Graphics2D g, int r0, int c0, int r1, int c1) {
        int i = 0;
        while (i <= 1) {
            g.drawRect(this.toX(c0 < c1 ? c0 : c1) + i, this.toY(r0 < r1 ? r0 : r1) + i, this.getCellSize() * (c0 < c1 ? c1 - c0 + 1 : c0 - c1 + 1) - i * 2, this.getCellSize() * (r0 < r1 ? r1 - r0 + 1 : r0 - r1 + 1) - i * 2);
            ++i;
        }
    }

    public void placeSquare(Graphics2D g, Square sq) {
        this.placeSquare(g, sq.r0(), sq.c0(), sq.r1(), sq.c1());
    }

    public void edgeCell(Graphics2D g, Address p, int w) {
        g.drawRect(this.toX(p), this.toY(p), this.getCellSize(), this.getCellSize());
    }

    public void edgeCell(Graphics2D g, Address p) {
        int w = 1;
        int i = 0;
        while (i < w) {
            g.drawRect(this.toX(p) + i, this.toY(p) + i, this.getCellSize() - i - i, this.getCellSize() - i - i);
            ++i;
        }
    }

    public void edgeArea(Graphics2D g, Area area) {
        for (Address pos : area) {
            int dir = 0;
            while (dir < 4) {
                Address neighbor = Address.nextCell(pos, dir);
                if (area.contains(neighbor)) {
                    if (dir >= 2) {
                        this.placeSideLine(g, SideAddress.get(pos, dir), 1);
                    }
                } else {
                    this.placeSideLine(g, SideAddress.get(pos, dir), 3);
                }
                ++dir;
            }
        }
    }

    public void placeMark(Graphics2D g, int r, int c) {
        switch (this.getMarkStyle()) {
            case 1: {
                this.placeCircle(g, r, c);
                break;
            }
            case 2: {
                this.placeFilledCircle(g, r, c);
                break;
            }
            case 3: {
                this.placeFilledSquare(g, r, c);
                break;
            }
            case 4: {
                this.placeCross(g, r, c);
                break;
            }
            case 5: {
                this.paintCell(g, r, c);
            }
        }
    }

    public void placeMark(Graphics2D g, Address p) {
        this.placeMark(g, p.r(), p.c());
    }

    @Override
    public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
        if (page >= 1) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        this.drawPanel(g2);
        return 0;
    }

    public void setCellSize(int cellSize) {
        this.cellSize = cellSize;
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public int getHalfCellSize() {
        return this.cellSize / 2;
    }

    public void setCircleSize(int circleSize) {
        this.circleSize = circleSize;
    }

    public int getCircleSize() {
        return this.circleSize;
    }

    public void setSmallCrossSize(int smallCrossSize) {
        this.smallCrossSize = smallCrossSize;
    }

    public int getSmallCrossSize() {
        return this.smallCrossSize;
    }

    public void setLinkWidth(int linkWidth) {
        this.linkWidth = linkWidth;
    }

    public int getLinkWidth() {
        return this.linkWidth;
    }

    public void setOffsetx(int offsetx) {
        this.offsetx = offsetx;
    }

    public int getOffsetx() {
        return this.offsetx;
    }

    public void setOffsety(int offsety) {
        this.offsety = offsety;
    }

    public int getOffsety() {
        return this.offsety;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBoardBorderColor(Color boardBorderColor) {
        this.boardBorderColor = boardBorderColor;
    }

    public Color getBoardBorderColor() {
        return this.boardBorderColor;
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setNumberColor(Color numberColor) {
        this.numberColor = numberColor;
    }

    public Color getNumberColor() {
        return this.numberColor;
    }

    public Color getErrorColor() {
        return this.errorColor;
    }

    public void setCursorColor(Color cursorColor) {
        this.cursorColor = cursorColor;
    }

    public Color getCursorColor() {
        return this.cursorColor;
    }

    public void setCursorMode(boolean cursorMode) {
        this.cursorMode = cursorMode;
    }

    public boolean isCursorMode() {
        return this.cursorMode;
    }

    protected void setNumberFont(Font numberFont) {
        this.numberFont = numberFont;
    }

    protected Font getNumberFont() {
        return this.numberFont;
    }

    protected void setCellCursor(CellCursor cellCursor) {
        this.cellCursor = cellCursor;
    }

    protected CellCursor getCellCursor() {
        return this.cellCursor;
    }

    public boolean isIndexMode() {
        return this.indexMode;
    }

    public void setIndexMode(boolean indexMode) {
        this.indexMode = indexMode;
    }

    public void changeIndexMode(boolean b) {
        this.indexMode = b;
        if (b) {
            this.setOffsetx(this.getCellSize());
            this.setOffsety(this.getCellSize());
        } else {
            this.setOffsetx(10);
            this.setOffsety(10);
        }
        this.updatePreferredSize();
    }

    Area getCopyRegion() {
        return this.copyRegion;
    }

    Area getPasteRegion() {
        return this.pasteRegion;
    }

    protected void drawCopyPasteRegion(Graphics2D g) {
        g.setColor(this.copyRegionColor);
        this.edgeArea(g, this.copyRegion);
        g.setColor(this.pasteRegionColor);
        this.edgeArea(g, this.pasteRegion);
    }
}

