/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.core;

import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Rotator2;
import pencilbox.common.core.Size;
import pencilbox.common.factory.ClassUtil;
import pencilbox.common.factory.PencilBoxClassException;

public class BoardCopierBase {
    public BoardBase duplicateBoard(BoardBase src) throws PencilBoxClassException {
        return this.duplicateBoard(src, 0);
    }

    public BoardBase duplicateBoard(BoardBase src, int n) throws PencilBoxClassException {
        BoardBase dst = (BoardBase)ClassUtil.createInstance(this.getClass(), "Board");
        if (Rotator2.isTransposed(n)) {
            dst.setSize(new Size(src.cols(), src.rows()));
        } else {
            dst.setSize(new Size(src.rows(), src.cols()));
        }
        this.copyBoardStates(src, dst, n);
        return dst;
    }

    public BoardBase duplicateBoard(BoardBase src, Size size) throws PencilBoxClassException {
        BoardBase dst = (BoardBase)ClassUtil.createInstance(this.getClass(), "Board");
        dst.setSize(size);
        this.copyBoardStates(src, dst, 0);
        return dst;
    }

    public void copyBoardStates(BoardBase src, BoardBase dst, int n) {
        Address from = Address.address(0, 0);
        Address to = this.rotateCornerAddress(src.rows(), src.cols(), n);
        Area region = src.getWholeBoardArea();
        this.copyRegion(src, dst, region, from, to, n);
    }

    private Address rotateCornerAddress(int rows, int cols, int rotation) {
        int R = 0;
        int C = 0;
        switch (rotation) {
            case 0: {
                R = 0;
                C = 0;
                break;
            }
            case 1: {
                R = cols - 1;
                C = 0;
                break;
            }
            case 2: {
                R = rows - 1;
                C = cols - 1;
                break;
            }
            case 3: {
                R = 0;
                C = rows - 1;
                break;
            }
            case 4: {
                R = 0;
                C = 0;
                break;
            }
            case 5: {
                R = 0;
                C = cols - 1;
                break;
            }
            case 6: {
                R = cols - 1;
                C = rows - 1;
                break;
            }
            case 7: {
                R = rows - 1;
                C = 0;
            }
        }
        return Address.address(R, C);
    }

    public void eraseRegion(BoardBase board, Area region) {
    }

    public void copyRegion(BoardBase srcBoard, BoardBase board, Area region, Address from, Address to, int rotation) {
    }

    public void eraseRegion2(BoardBase board, Area region) {
        board.startCompoundUndo();
        this.eraseRegion(board, region);
        board.stopCompoundUndo();
        board.initBoard();
    }

    public void copyRegion2(BoardBase board, Area region, Address from, Address to, int rotation) {
        try {
            BoardBase srcBoard = this.duplicateBoard(board);
            board.startCompoundUndo();
            this.copyRegion(srcBoard, board, region, from, to, rotation);
            board.stopCompoundUndo();
            board.initBoard();
        }
        catch (PencilBoxClassException e) {
            e.printStackTrace();
        }
    }

    public void moveRegion(BoardBase board, Area region, Address from, Address to, int rotation) {
        try {
            BoardBase srcBoard = this.duplicateBoard(board);
            board.startCompoundUndo();
            this.eraseRegion(board, region);
            this.copyRegion(srcBoard, board, region, from, to, rotation);
            board.stopCompoundUndo();
            board.initBoard();
        }
        catch (PencilBoxClassException e) {
            e.printStackTrace();
        }
    }

    protected Address translateAndRotateAddress(Address pos, Address from, Address to, int rotation) {
        return Rotator2.translateAndRotateAddress(pos, from, to, rotation);
    }
}

