/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.tentaisho;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Direction;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelBase;
import pencilbox.tentaisho.Area;
import pencilbox.tentaisho.Board;

public class Panel
extends PanelBase {
    private Board board;
    private boolean hideStarMode = false;
    private boolean showAreaBorderMode = true;
    private boolean indicateErrorMode = false;
    private boolean separateAreaColorMode = false;
    private Color areaBorderColor = new Color(153);
    private Color noStarAreaColor = new Color(0xFFFF99);
    private Color whiteAreaColor = new Color(0xAAFFFF);
    private Color blackAreaColor = new Color(0xFFAAFF);
    private Color draggingAreaColor = new Color(0xCCFFFF);
    private Color starColor = Color.BLACK;
    private Color borderColor = new Color(0xFF0099);
    private int halfStarSize = 3;
    private Area draggingArea;

    public Panel() {
        this.setGridColor(Color.GRAY);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    Area getDraggingArea() {
        return this.draggingArea;
    }

    void setDraggingArea(Area draggingArea) {
        this.draggingArea = draggingArea;
    }

    public int getHalfStarSize() {
        return this.halfStarSize;
    }

    public void setHalfStarSize(int halfStarSize) {
        this.halfStarSize = halfStarSize;
    }

    public Color getAreaBorderColor() {
        return this.areaBorderColor;
    }

    public void setAreaBorderColor(Color areaBorderColor) {
        this.areaBorderColor = areaBorderColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getBlackAreaColor() {
        return this.blackAreaColor;
    }

    public void setBlackAreaColor(Color blackAreaColor) {
        this.blackAreaColor = blackAreaColor;
    }

    public Color getWhiteAreaColor() {
        return this.whiteAreaColor;
    }

    public void setWhiteAreaColor(Color whiteAreaColor) {
        this.whiteAreaColor = whiteAreaColor;
    }

    public boolean isShowAreaBorderMode() {
        return this.showAreaBorderMode;
    }

    public void setShowAreaBorderMode(boolean showAreaBorderMode) {
        this.showAreaBorderMode = showAreaBorderMode;
    }

    public boolean isHideStarMode() {
        return this.hideStarMode;
    }

    public void setHideStarMode(boolean hideStarMode) {
        this.hideStarMode = hideStarMode;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    public boolean isSeparateAreaColorMode() {
        return this.separateAreaColorMode;
    }

    public void setSeparateAreaColorMode(boolean separateAreaColorMode) {
        this.separateAreaColorMode = separateAreaColorMode;
    }

    @Override
    public void setDisplaySize(int cellSize) {
        this.halfStarSize = (int)((double)cellSize * 0.15);
        super.setDisplaySize(cellSize);
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.paintAreas(g);
        this.drawGrid(g);
        if (!this.isHideStarMode()) {
            this.drawStars(g);
        }
        if (this.isShowAreaBorderMode()) {
            this.drawAreaBorders(g);
        }
        this.drawEdges(g);
        this.drawBoardBorder(g);
    }

    private void paintAreas(Graphics2D g) {
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.board.getArea(p) != null) {
                if (this.board.getArea(p) == this.draggingArea) {
                    g.setColor(this.draggingAreaColor);
                } else {
                    int starType = this.board.getArea(p).getStarType();
                    g.setColor(this.whiteAreaColor);
                    if (this.isSeparateAreaColorMode()) {
                        if (starType == -1) {
                            g.setColor(this.getErrorColor());
                        } else if (starType == 1) {
                            g.setColor(this.whiteAreaColor);
                        } else if (starType == 2) {
                            g.setColor(this.blackAreaColor);
                        } else {
                            g.setColor(this.noStarAreaColor);
                        }
                    }
                    if (this.isIndicateErrorMode()) {
                        if (starType == -1) {
                            g.setColor(this.getErrorColor());
                        } else if (starType == 0) {
                            g.setColor(this.noStarAreaColor);
                        } else if (!this.board.getArea(p).isPointSymmetry()) {
                            g.setColor(this.getErrorColor());
                        }
                    }
                }
                this.paintCell(g, p);
            }
            ++n2;
        }
    }

    private void drawStars(Graphics2D g) {
        int r = 0;
        while (r < this.board.rows() * 2 - 1) {
            int c = 0;
            while (c < this.board.cols() * 2 - 1) {
                int n = this.board.getStar(r, c);
                if (n > 0) {
                    this.placeStar(g, r, c, n);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawAreaBorders(Graphics2D g) {
        g.setColor(this.areaBorderColor);
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int[] nArray = Direction.DN_RT;
            int n3 = Direction.DN_RT.length;
            int n4 = 0;
            while (n4 < n3) {
                int d = nArray[n4];
                Address p1 = p.nextCell(d);
                SideAddress b = SideAddress.get(p, d);
                if (this.board.isSideOn(b) && this.board.getArea(p) != this.board.getArea(p1)) {
                    this.placeSideLine(g, b);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void drawEdges(Graphics2D g) {
        g.setColor(this.borderColor);
        SideAddress[] sideAddressArray = this.board.borderAddrs();
        int n = sideAddressArray.length;
        int n2 = 0;
        while (n2 < n) {
            SideAddress p = sideAddressArray[n2];
            int state = this.board.getEdge(p);
            if (state == 1) {
                this.placeSideLine(g, p);
            }
            ++n2;
        }
    }

    public void placeStar(Graphics2D g, int r, int c, int star) {
        if (star == 1) {
            if (this.isSeparateAreaColorMode()) {
                g.setColor(this.getWhiteAreaColor());
            } else {
                g.setColor(this.getBackgroundColor());
            }
        } else if (star == 2) {
            if (this.isSeparateAreaColorMode()) {
                g.setColor(this.getBlackAreaColor());
            } else {
                g.setColor(this.starColor);
            }
        }
        this.fillCircle(g, this.getOffsetx() + this.getCellSize() * (c + 1) / 2, this.getOffsety() + this.getCellSize() * (r + 1) / 2, this.getHalfStarSize());
        g.setColor(this.starColor);
        this.drawCircle(g, this.getOffsetx() + this.getCellSize() * (c + 1) / 2, this.getOffsety() + this.getCellSize() * (r + 1) / 2, this.getHalfStarSize());
    }

    @Override
    public void drawCursor(Graphics2D g) {
        if (this.isProblemEditMode()) {
            g.setColor(this.getCursorColor());
            g.drawRect(this.getOffsetx() + (this.getCellSize() * this.getCellCursor().c() + this.getHalfCellSize()) / 2, this.getOffsety() + (this.getCellSize() * this.getCellCursor().r() + this.getHalfCellSize()) / 2, this.getHalfCellSize(), this.getHalfCellSize());
        }
    }
}

